      SUBROUTINE  loadspm
c
c...Load SPM Photometric Standards
c
      INCLUDE
     *            'ugapcs0.inc'
      INTEGER
     *            id, nout
      DOUBLE PRECISION
     *            r, d, mv, bmv, mb, mr, mj, mf, mn, mo, me
c
 9001 FORMAT (i8, 2f11.0, 2f6.0)
 9002 FORMAT (' N(SPM)=', i5, '  N(out)=', i5)
c
c...Read, Convert, And Save
c
  100 nspm = 0
      nout = 0
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='spm_1_0.ccd',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
  110 READ (1,9001,end=120) id,r,d,mv,bmv
      mb = mv+bmv
      CALL tabinterp(mb,mv,mv, 1,mj)
      CALL tabinterp(mb,mv,mv, 2,mf)
      IF ((mj.ne.TAG).and.(mf.ne.TAG)) THEN
        nspm = nspm+1
        spmra(nspm) = 360000.0D00*r
        spmspd(nspm) = 360000.0D00*(d+90.0D00)
        spmmj(nspm) = 100.0D00*mj
        spmmf(nspm) = 100.0D00*mf
        spmid(nspm) = id
        idx(nspm) = nspm
      ELSE
        nout = nout+1
      ENDIF
      GO TO 110
  120 CLOSE (1)
c
c...Sort
c
      CALL iuqsrt(nspm,spmra,idx)
      CALL ireord(nspm,idx,spmspd,tmp)
      CALL ireord(nspm,idx,spmmj,tmp)
      CALL ireord(nspm,idx,spmmf,tmp)
      CALL ireord(nspm,idx,spmid,tmp)
      WRITE (*,9002) nspm,nout
      RETURN
      END
