      SUBROUTINE  sbtruth
c
c...Generate A Truth File
c
      INCLUDE
     *            'ugapcs0.inc'
      PARAMETER
     *            nominal = 12.0D00
      DOUBLE PRECISION
     *            a0, b0, c0, b1, c1, a, b, c, d, r1, r2, s1, s2,
     *            x, y
      INTEGER
     *            i, doit, n
c
 9001 FORMAT (' Ooops - No Crossing', i11)
 9002 FORMAT (i5, 2f10.2, 5f10.5)
 9003 FORMAT (' SBTRUTH Saved ', i3, ' Solutions')
c
c...Initialization
c
  100 OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='sbtruth.0',
     *      status='unknown',
     *      unit=1
     *     )
      n = 0
      DO i=1,NFMAX
        doit = 0
c
c...Was There A USNO Solution?
c
        IF (usnoid(i,1).ne.0) THEN
          doit = 1
          a0 = jcoef(nplate+2)
          b0 = jcoef(nplate+1)
          c0 = usno(i,1)
c
c...Was There An SPM Solution?
c
        ELSEIF (flut(i).ne.0) THEN
          doit = 1
          a0 = jcoef(nplate+2)
          b0 = jcoef(nplate+1)
          c0 = jcoef(flut(i))
c
c...Compute The Crossing
c
        ENDIF
        IF (doit.ne.0) THEN
          b1 = sbbright(2,i)
          c1 = sbbright(1,i)
          a = a0
          b = b0-b1
          c = c0-c1
          d = b*b - 4.0D00*a*c
          IF (d.lt.0.0D00) THEN
            WRITE (*,9001) i
          ELSE
            d = SQRT(d)
            r1 = (-b + d)/(a+a)
            r2 = (-b - d)/(a+a)
            s1 = ABS(r1-NOMINAL)
            s2 = ABS(r2-NOMINAL)
            IF (s1.lt.s2) THEN
              x = r1
            ELSE
              x = r2
            ENDIF
            y = b1*x + c1
            WRITE (1,9002) i,x,y,c1,b1,c0,b0,a0
            n = n+1
          ENDIF
        ENDIF
      ENDDO
      CLOSE (1)
      WRITE (*,9003) n
      RETURN
      END
