      PROGRAM  verify
c
c...Make Sure Catalog Is Sorted, ACC Is Correct, And Count QUALITY
c
      IMPLICIT
     *          NONE
      PARAMETER
     *          nmax = 4*1000*1000,
     *          nacc = 96,
     *          factor = (25*15*36*100)
      INTEGER
     *          z, n, total, C_GENLEN, nlb, buf(3,NMAX), qual(6),
     *          frst(NACC), long(NACC), i, m, vec(3*NMAX), q, xm,
     *          z1, z2
      CHARACTER*64
     *          lb
      BYTE
     *          bb(65)
      EQUIVALENCE
     *          (buf(1,1),vec(1))
c
 9001 FORMAT ('/ux6/xpmm/zone/elgb', i4.4, '.cat')
 9002 FORMAT (' N=', i10, ' Q=', 6i10)
 9003 FORMAT (' Zone=', i4, '   N=', i12)
 9004 FORMAT (5x, 2i12)
 9005 FORMAT (' Length Error', 3i10)
 9006 FORMAT (' Out Of Order', 4i12)
 9007 FORMAT (' Working On Zone ', i4)
 9008 FORMAT (' Illegal Quality', 3i12)
 9009 FORMAT (' ACC Error', 5i12)
c
c...Loop Over All Zones
c
  100 total = 0
      DO n=1,6
        qual(n) = 0
      ENDDO
      DO z=0,1725,75
        WRITE (*,9007) z
        WRITE (lb,9001) z
        nlb = 27
        DO n=1,nlb
          bb(n) = ICHAR(lb(n:n))
        ENDDO
        bb(nlb+1) = 0
        n = C_GENLEN(bb)
        n = n/12
        total = total+n
c
c...Load The ACC File
c
        lb(nlb-2:nlb) = 'acc'
        OPEN (
     *        access='sequential',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        form='formatted',
     *        name=lb(1:nlb),
     *        readonly,
     *        shared,
     *        status='old',
     *        unit=1
     *       )
        DO i=1,NACC
          READ (1,9004) frst(i),long(i)
        ENDDO
        CLOSE (1)
        m = frst(NACC)+long(NACC)-1
        IF (m.ne.n) THEN
          WRITE (*,9005) z,n,m
          CALL EXIT
        ENDIF
c
c...Eat The CAT File
c
        lb(nlb-2:nlb) = 'cat'
        OPEN (
     *        access='direct',
     *        carriagecontrol='none',
     *        convert='big_endian',
     *        dispose='keep',
     *        form='unformatted',
     *        name=lb(1:nlb),
     *        readonly,
     *        recl=(3*n),
     *        recordtype='fixed',
     *        shared,
     *        status='old',
     *        unit=1
     *       )
        READ (1,rec=1) (vec(i),i=1,3*n)
        CLOSE (1)
c
c...Verify That It Is Sorted
c
        DO i=2,n
          IF (buf(1,i-1).gt.buf(1,i)) THEN
            WRITE (*,9006) z,i,buf(1,i-1),buf(1,i)
            CALL EXIT
          ENDIF
        ENDDO
c
c...Verify ACC
c
        DO i=2,96
          IF (frst(i).ne.(frst(i-1)+long(i-1))) THEN
            WRITE (*,9009) z,i,frst(i-1),long(i-1),frst(i)
            CALL EXIT
          ENDIF
        ENDDO
        DO i=2,96
          z1 = buf(1,frst(i)-1)/FACTOR
          z2 = buf(1,frst(i)  )/FACTOR
          IF (z2.ne.(z1+1)) THEN
            WRITE (*,9009) z,i,z1,z2
            CALL EXIT
          ENDIF
        ENDDO
c
c...Accumulate Quality Statistics
c
        DO i=1,n
          CALL getqual(buf(3,i),q,xm)
          IF ((q.lt.1).or.(q.gt.6)) THEN
            WRITE (*,9008) z,i,buf(3,i)
            CALL EXIT
          ENDIF
          qual(q) = qual(q)+1
        ENDDO
      ENDDO
      WRITE (*,9002) total,(qual(i),i=1,6)
      CALL EXIT
      END
