      SUBROUTINE  irdread(ident,nq,qrmin,qrmax,qdmin,qdmax)
c
c...Open And Read The IRD File
c
      INCLUDE
     *            'genover.inc'
      CHARACTER*(*)
     *            ident
      INTEGER
     *            nq, qrmin(*), qrmax(*), qdmin(*), qdmax(*), i, nlb,
     *            n, C_GENLEN, rmn, rmx, dmn, dmx, j, r, d, npair,
     *            field
      CHARACTER*64
     *            lb
      CHARACTER*2
     *            sv
      BYTE
     *            bb(65)
c
 9001 FORMAT (' IRD File Is Too Big', 2i12)
 9002 FORMAT (' Cannot Find ', a)
 9003 FORMAT (i10)
 9004 FORMAT (' Cannot Find PHD File For ', a)
 9005 FORMAT (2x, i10)
 9006 FORMAT (' N=', i10, ' After JF Pair Processing')
 9007 FORMAT (' NA=', i10)
 9008 FORMAT (' Cannot Find INF File For ', a)
 9009 FORMAT (2x, i4)
c
c...Cheat.  Compute Length From Byte Count In IRD File
c
  100 IF (ident(1:2).eq.'sj') THEN
        CALL f_doenv('SJIRD:'//ident//'.ird',nlb,lb)
      ELSEIF (ident(1:2).eq.'sf') THEN
        CALL f_doenv('SFIRD:'//ident//'.ird',nlb,lb)
      ELSEIF (ident(1:2).eq.'sn') THEN
        CALL f_doenv('SNIRD:'//ident//'.ird',nlb,lb)
      ELSE
        CALL f_doenv(ident,nlb,lb)
      ENDIF
      DO i=1,nlb
        bb(i) = ICHAR(lb(i:i))
      ENDDO
      bb(nlb+1) = 0
      n = C_GENLEN(bb)
      IF (MOD(n,8).ne.0) GO TO 200
      n = n/8
      IF (n.gt.NBUF) THEN
        WRITE (*,9001) n,NBUF
        CALL EXIT
      ENDIF
      READ (ident,9009) field
c
c...Read The File Now That We Know How Big It Is
c
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      err=200,
     *      form='unformatted',
     *      name=lb(1:nlb),
     *      readonly,
     *      recl=n,
     *      recordtype='fixed',
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,rec=1) (rbuf(i),i=1,n)
      READ (1,rec=2) (dbuf(i),i=1,n)
      CLOSE (1)
c
c...Get Calibrated Magnitudes
c
      sv = ident(1:2)
      IF ((sv(1:1).ge.'a').and.(sv(1:1).le.'z')) THEN
        sv(1:1) = CHAR(ICHAR(sv(1:1))-32)
      ENDIF
      IF ((sv(2:2).ge.'a').and.(sv(2:2).le.'z')) THEN
        sv(2:2) = CHAR(ICHAR(sv(2:2))-32)
      ENDIF
      CALL f_doenv(sv//'PHD:'//ident//'.phd',nlb,lb)
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      err=102,
     *      form='unformatted',
     *      name=lb(1:nlb),
     *      readonly,
     *      recl=n,
     *      recordtype='fixed',
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,rec=1) (mbuf(i),i=1,n)
      CLOSE (1)
      GO TO 104
  102 WRITE (*,9004) ident
      CALL realread(ident,n,i)
      IF (i.eq.0) THEN
        WRITE (*,9008) ident
        DO i=1,n
          mbuf(i) = 0
        ENDDO
      ENDIF
  104 CONTINUE
c
c...Long Version Since IRD Is Not In Order
c
      DO j=1,nq
        rmn = qrmin(j)
        rmx = qrmax(j)
        dmn = qdmin(j)
        dmx = qdmax(j)
        DO i=1,n
          r = rbuf(i)
          IF ((r.ge.rmn).and.(r.le.rmx)) THEN
            d = dbuf(i)
            IF ((d.ge.dmn).and.(d.le.dmx)) THEN
              na = na+1
              ara(na) = r
              arsave(na) = r
              adec(na) = d
              adsave(na) = d
              amag(na) = mbuf(i)
              aid(na) = i
              afld(na) = field
            ENDIF
          ENDIF
        ENDDO
      ENDDO
      WRITE (*,9007) na
      RETURN
c
c...Errors
c
  200 WRITE (*,9002) ident
      RETURN
      END
