      SUBROUTINE  apsgobble
c
c...Fill BJ List
c
      INCLUDE
     *            'genover.inc'
      INTEGER
     *            nlb, ntb, id, i
      DOUBLE PRECISION
     *            rhh, rmm, rss, ddd, dmm, dss, mag, color,
     *            r2000, d2000, r1950, d1950, epoch
      CHARACTER*64
     *            lb, tb
c
 9002 FORMAT (q, a)
 9003 FORMAT (' Cannot Open ', a)
 9004 FORMAT (2(1x,f2.0),1x,f5.2, 2x,a, 2(f2.0,1x),f5.2,
     *        9x,f5.0, 9x,f5.0, 55x,i8)
 9005 FORMAT (' N(APS)=', i6)
 9006 FORMAT (' Error Parsing >>', a, '<<')
c
c...Get File And Open It
c
  100 CALL f_doenv('DGM:'//root(1:nroot)//'.o',nlb,lb)
      naps = 0
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=200,
     *      form='formatted',
     *      name=lb(1:nlb),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      DO i=1,2
  110   READ (1,9002) (nlb,lb)
        IF (INDEX(lb,'+---').le.0) GO TO 110
      ENDDO
c
c...Ingest The File And Convert To UJ Integers
c
  120 READ (1,9002,err=120,end=140) nlb,lb
      READ (lb(1:nlb),9004,err=130) rhh,rmm,rss,ddd,dmm,dss,mag,color,id
      r1950 = rhh + rmm/60.0D00 + rss/3600.0D00
      d1950 = ABS(ddd) + dmm/60.0D00 + dss/3600.0D00
      IF (INDEX(lb(15:26),'-').gt.0) THEN
        d1950 = -d1950
      ENDIF
      r1950 = r1950*ra_to_rad
      d1950 = d1950*dec_to_rad
      epoch = 1995.5D00
      CALL sla_FK45Z(r1950,d1950,epoch,r2000,d2000)
      r2000 = r2000/ra_to_rad
      d2000 = d2000/dec_to_rad
      naps = naps+1
      apsid(naps) = id
      apsra(naps) = r2000*DRFACTOR + 0.5D00
      apsdec(naps) = d2000*DDFACTOR + DOFFSET + 0.5D00
      apsomag(naps) = mag*DMFACTOR + 0.5D00
      apsemag(naps) = apsomag(naps) - DMFACTOR*color
      GO TO 120
  130 WRITE (*,9006) lb(1:nlb)
      GO TO 120
c
c...All Done.
c
  140 CLOSE (1)
      WRITE (*,9005) naps
      RETURN
c
c...Errors
c
  200 WRITE (*,9003) lb(1:nlb)
      RETURN
      END
