      SUBROUTINE  irdread(ident,nq,qrmin,qrmax,qdmin,qdmax)
c
c...Open And Read The IRD File
c
      INCLUDE
     *            'genover.inc'
      CHARACTER*(*)
     *            ident
      INTEGER
     *            nq, qrmin(*), qrmax(*), qdmin(*), qdmax(*), i, nlb,
     *            n, C_GENLEN, rmn, rmx, dmn, dmx, j, r, d, npair,
     *            field, npbuf, which, npb, nxb
      CHARACTER*64
     *            lb, pb, xb
      CHARACTER*2
     *            sv
      BYTE
     *            bb(65)
c
 9001 FORMAT (' IRD File Is Too Big', 2i12)
 9002 FORMAT (' Cannot Find ', a)
 9003 FORMAT (i10)
 9004 FORMAT (' Cannot Find PHD File For ', a)
 9005 FORMAT (2x, i10)
 9006 FORMAT (' N=', i10, ' After JF Pair Processing')
 9007 FORMAT (' NA=', i10)
 9008 FORMAT (' Cannot Find INF File For ', a)
 9009 FORMAT (2x, i4)
 9010 FORMAT (' N(pair)=', i6, ' From ', a)
c
c...Cheat.  Compute Length From Byte Count In IRD File
c
  100 IF (ident(1:2).eq.'sj') THEN
        CALL f_doenv('SJIRD:'//ident//'.ird',nlb,lb)
        CALL f_doenv('AUXJF:kf'//ident(3:6)//'.fit',npb,pb)
        CALL f_doenv('AUXJN:kn'//ident(3:6)//'.fit',nxb,xb)
        which = 1
      ELSEIF (ident(1:2).eq.'sf') THEN
        CALL f_doenv('SFIRD:'//ident//'.ird',nlb,lb)
        CALL f_doenv('AUXJF:kf'//ident(3:6)//'.fit',npb,pb)
        nxb = 0
        which = 2
      ELSEIF (ident(1:2).eq.'sn') THEN
        CALL f_doenv('SNIRD:'//ident//'.ird',nlb,lb)
        CALL f_doenv('AUXJN:kn'//ident(3:6)//'.fit',npb,pb)
        nxb = 0
        which = 2
      ELSE
        CALL f_doenv(ident,nlb,lb)
        CALL f_doenv(ident,npb,pb)
        nxb = 0
        which = 1
      ENDIF
      DO i=1,nlb
        bb(i) = ICHAR(lb(i:i))
      ENDDO
      bb(nlb+1) = 0
      n = C_GENLEN(bb)
      IF (MOD(n,8).ne.0) GO TO 200
      n = n/8
      IF (n.gt.NBUF) THEN
        WRITE (*,9001) n,NBUF
        CALL EXIT
      ENDIF
      READ (ident,9009) field
c
c...Read The File Now That We Know How Big It Is
c
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      err=200,
     *      form='unformatted',
     *      name=lb(1:nlb),
     *      readonly,
     *      recl=n,
     *      recordtype='fixed',
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,rec=1) (rbuf(i),i=1,n)
      READ (1,rec=2) (dbuf(i),i=1,n)
      CLOSE (1)
c
c...Get Calibrated Magnitudes
c
      sv = ident(1:2)
      IF ((sv(1:1).ge.'a').and.(sv(1:1).le.'z')) THEN
        sv(1:1) = CHAR(ICHAR(sv(1:1))-32)
      ENDIF
      IF ((sv(2:2).ge.'a').and.(sv(2:2).le.'z')) THEN
        sv(2:2) = CHAR(ICHAR(sv(2:2))-32)
      ENDIF
      CALL f_doenv(sv//'PHD:'//ident//'.phd',nlb,lb)
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      err=110,
     *      form='unformatted',
     *      name=lb(1:nlb),
     *      readonly,
     *      recl=n,
     *      recordtype='fixed',
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,rec=1) (mbuf(i),i=1,n)
      CLOSE (1)
      GO TO 120
  110 CALL realread(ident,n,i)
      IF (i.eq.0) THEN
        WRITE (*,9008) ident
        DO i=1,n
          mbuf(i) = 0
        ENDDO
      ENDIF
  120 CONTINUE
c
c...Get Pairs (If Possible)
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=130,
     *      form='formatted',
     *      name=pb(1:npb),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9005)
      READ (1,9005)
      READ (1,9005) npbuf
      CLOSE (1)
      pb(npb-2:npb) = 'par'
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      form='unformatted',
     *      name=pb(1:npb),
     *      readonly,
     *      recl=npbuf,
     *      recordtype='fixed',
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,rec=which) (tmp(i),i=1,npbuf)
      CLOSE (1)
      DO i=1,n
        idx(i) = 0
      ENDDO
      DO i=1,npbuf
        idx(tmp(i)) = 1
      ENDDO
      WRITE (*,9010) npbuf,pb(1:npb)
      GO TO 140
  130 DO i=1,n
        idx(i) = 1
      ENDDO
  140 CONTINUE
c
c...Try Again To Get Logical OR Of JF/JN In J Catalog
c
      IF (nxb.gt.0) THEN
        OPEN (
     *        access='sequential',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        err=150,
     *        form='formatted',
     *        name=xb(1:nxb),
     *        readonly,
     *        shared,
     *        status='old',
     *        unit=1
     *       )
        READ (1,9005)
        READ (1,9005)
        READ (1,9005) npbuf
        CLOSE (1)
        xb(nxb-2:nxb) = 'par'
        OPEN (
     *        access='direct',
     *        carriagecontrol='none',
     *        convert='big_endian',
     *        dispose='keep',
     *        err=150,
     *        form='unformatted',
     *        name=xb(1:nxb),
     *        readonly,
     *        recl=npbuf,
     *        recordtype='fixed',
     *        shared,
     *        status='old',
     *        unit=1
     *       )
        READ (1,rec=which) (tmp(i),i=1,npbuf)
        CLOSE (1)
        DO i=1,npbuf
          idx(tmp(i)) = 1
        ENDDO
        WRITE (*,9010) npbuf,xb(1:nxb)
  150   CONTINUE
      ENDIF
c
c...Long Version Since IRD Is Not In Order
c
      rmn = 0
      do i=1,n
        if (idx(i).ne.0) then
          if (rmn.eq.0) then
            rmn = rbuf(i)
            rmx = rmn
            dmn = dbuf(i)
            dmx = dmn
          else
            rmn = min(rmn,rbuf(i))
            rmx = max(rmx,rbuf(i))
            dmn = min(dmn,dbuf(i))
            dmx = max(dmx,dbuf(i))
          endif
        endif
      enddo
      DO j=1,nq
        rmn = qrmin(j)
        rmx = qrmax(j)
        dmn = qdmin(j)
        dmx = qdmax(j)
        DO i=1,n
          IF (idx(i).ne.0) THEN
            r = rbuf(i)
            IF ((r.ge.rmn).and.(r.le.rmx)) THEN
              d = dbuf(i)
              IF ((d.ge.dmn).and.(d.le.dmx)) THEN
                na = na+1
                ara(na) = r
                arsave(na) = r
                adec(na) = d
                adsave(na) = d
                amag(na) = mbuf(i)
                aid(na) = i
                afld(na) = field
              ENDIF
            ENDIF
          ENDIF
        ENDDO
      ENDDO
      WRITE (*,9007) na
      RETURN
c
c...Errors
c
  200 WRITE (*,9002) ident
      RETURN
      END
