      PROGRAM  debug1
c
c...Verify Indices
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         npmax = 10000,
     *         nsmax = 1*1000*1000
      INTEGER
     *         sjid(NPMAX), sfid(NPMAX), np, i, buf(11), nlb, j, k,
     *         pj(NSMAX), pf(NSMAX), ncoef, njf, jid, fid, nsame, nmiss,
     *         ndiff
      DOUBLE PRECISION
     *         xcoef(16), ycoef(16)
      CHARACTER*64
     *         lb
c
 9001 FORMAT (i8, i2, 3i12, 3(i4,i12))
 9002 FORMAT (' NP=', i10)
 9003 FORMAT (i2, i10)
 9004 FORMAT (i2, 2(1x,e15.8))
 9005 FORMAT (' NJF=', i10)
 9006 FORMAT (' Same=', i10, '  Diff=', i10, '  Miss=', i10)
c
c...Load Pairs From Selected Pair
c
  100 OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='sa57b.abs',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      np = 0
      DO i=1,7
        READ (1,9001)
      ENDDO
  110 READ (1,9001,end=120) (buf(i),i=1,11)
      IF ((buf(6).eq.443).and.(buf(8).eq.443)) THEN
        np = np+1
        sjid(np) = buf(7)
        sfid(np) = buf(9)
      ENDIF
      GO TO 110
  120 CLOSE (1)
      WRITE (*,9002) np
c
c...Load Pairs File
c
      lb = '/uz6/xpmm/auxjf/kf0443.fit'
      nlb = 26
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name=lb(1:nlb),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9003)
      READ (1,9003)
      READ (1,9003) ncoef,njf
      DO i=1,ncoef
        READ (1,9004) j,xcoef(i),ycoef(i)
      ENDDO
      CLOSE (1)
      lb(nlb-2:nlb) = 'par'
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      form='unformatted',
     *      name=lb(1:nlb),
     *      readonly,
     *      recl=njf,
     *      recordtype='fixed',
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,rec=1) (pj(i),i=1,njf)
      READ (1,rec=2) (pf(i),i=1,njf)
      CLOSE (1)
      WRITE (*,9005) njf
c
c...Outer Loop Over 2MASS Pairs
c
      nsame = 0
      ndiff = 0
      nmiss = 0
      DO i=1,np
        jid = sjid(i)
        fid = sfid(i)
c
c...Inner Loop Over Whole Plate
c
        DO j=1,njf
          IF (jid.eq.pj(j)) THEN
            IF (fid.eq.pf(j)) THEN
              nsame = nsame+1
            ELSE
              ndiff = ndiff+1
      write (*,9991) i,jid,fid,j,pj(i),pf(i)
      do k=j-10,j+10
      write (*,9991) k,pj(k),pf(k)
      enddo
      pause
 9991 format (6i10)
            ENDIF
            GO TO 130
          ENDIF
        ENDDO
        nmiss = nmiss+1
  130   CONTINUE
      ENDDO
      WRITE (*,9006) nsame,ndiff,nmiss
c
c...All Done
c
      CALL EXIT
      END
