      SUBROUTINE  agobble(mode)
c
c...Recover Catalog Piece(s) That Covers B List
c
      INCLUDE
     *         'genover.inc'
      INTEGER
     *         rmin, rmax, dmin, dmax, nq, qrmin(4), qrmax(4),
     *         qdmin(4), qdmax(4), i, eps, s, nlb, nfp1, fp1(20), nfp2,
     *         fp2(20), loop, mode
      CHARACTER*6
     *         tb
      DOUBLE PRECISION
     *         d, x1, x2, y1, y2, xx1, xx2, yy1, yy2
      CHARACTER*64
     *          lb
c
 9002 FORMAT (' Looking For SJ', i4.4)
 9003 FORMAT ('sj', i4.4)
 9004 FORMAT (' Search RA(', f6.3, ',', f6.3, ')  Dec(', f7.3, ',',
     *        f7.3, ')')
 9005 FORMAT (30x, 2f10.0)
 9006 FORMAT (' Enter Reference Catalog Limits: ' $)
 9007 FORMAT (q, 4f10.0)
c
c...Get Limits From B
c
  100 dmin = bdec(1)
      dmax = dmin
      rmin = bra(1)
      rmax = rmin
      DO i=2,nb
        dmin = MIN(dmin,bdec(i))
        dmax = MAX(dmax,bdec(i))
        rmin = MIN(rmin,bra(i))
        rmax = MAX(rmax,bra(i))
      ENDDO
c
c...Pad To Allow For Error Radius
c
      d = MAX(ABS(dmin-DOFFSET),ABS(dmax-DOFFSET))/DDFACTOR
      eps = 100.0D00*radius/COSD(d)
      IF ((rmax-rmin).lt.HALF_CIRCLE) THEN
        field_mra = ((rmax+rmin+1)/2)/DRFACTOR
        field_mdec = (((dmax+dmin+1)/2)-DDOFFSET)/DDFACTOR
        rmin = rmin-eps
        IF (rmin.lt.0) THEN
          rmin = rmin+CIRCLE
        ENDIF
        rmax = rmax+eps
        IF (rmax.ge.CIRCLE) THEN
          rmax = rmax-CIRCLE
        ENDIF
      ELSE
        field_mra = ((rmax+rmin+1-CIRCLE)/2)/DRFACTOR
        IF (field_mra.lt.0.0D00) THEN
          field_mra = field_mra + 24.0D00
        ENDIF
        field_mdec = (((dmax+dmin+1)/2)-DDOFFSET)/DDFACTOR
        rmin = rmin+eps
        rmax = rmax-eps
      ENDIF
      dmin = dmin-eps
      dmax = dmax+eps
c
c...MODE==0 Means Recover Tangent Point From 00
c
      IF (mode.eq.0) THEN
        CALL f_doenv('AUX2MASS:irdsjcomahr0.p.ps_s.inf',nlb,lb)
        OPEN (
     *        access='sequential',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        form='formatted',
     *        name=lb(1:nlb),
     *        readonly,
     *        shared,
     *        status='old',
     *        unit=1
     *       )
        READ (1,9005) field_mra,field_mdec
        CLOSE (1)
        WRITE (tb,9003)
        survey = tb(1:2)
        RETURN
c
c...MODE==1 Means We Are Generating The Reference Catalog
c
      ELSE
        x1 = rmin/DRFACTOR
        x2 = rmax/DRFACTOR
        y1 = (dmin-DDOFFSET)/DDFACTOR
        y2 = (dmax-DDOFFSET)/DDFACTOR
        WRITE (*,9004) x1,x2,y1,y2
        WRITE (*,9006)
        READ (*,9007) i,xx1,xx2,yy1,yy2
        IF (i.gt.0) THEN
          x1 = xx1
          x2 = xx2
          y1 = yy1
          y2 = yy2
          rmin = x1*DRFACTOR
          rmax = x2*DRFACTOR
          dmin = y1*DDFACTOR+DDOFFSET
          dmax = y2*DDFACTOR+DDOFFSET
        ENDIF
      ENDIF
c
c...Look Up POSS Plates, and Loop Over Them
c
      CALL sub4c(x1,x2,y1,y2,nfp1,fp1,nfp2,fp2)
      na = 0
      DO loop=1,nfp2
        WRITE (*,9002) fp2(loop)
        IF ((rmax-rmin).lt.HALF_CIRCLE) THEN
          nq = 1
          qrmin(1) = rmin
          qrmax(1) = rmax
        ELSE
          nq = 2
          qrmin(1) = 0
          qrmax(1) = rmin
          qrmin(2) = rmax
          qrmax(2) = CIRCLE-1
        ENDIF
        DO i=1,nq
          qdmin(i) = dmin
          qdmax(i) = dmax
        ENDDO
        WRITE (tb,9003) fp2(loop)
        survey = tb(1:2)
        CALL irdread(tb,nq,qrmin,qrmax,qdmin,qdmax)
      ENDDO
      RETURN
      END
