      SUBROUTINE  psfit(iz,zcoef,szcoef,ez)
c
c...Fit PS to Projected P.PS_S Coordinates
c
      INCLUDE
     *            'genover.inc'
      DOUBLE PRECISION
     *            x, y, z, ez, chisq, zcoef(*), szcoef(*), zc, zr
      INTEGER
     *            i, j, k, ising, iz(*)
c
 9001 FORMAT (' Singular Matrix In PSFIT')
c
c...Initialization
c
  100 DO i=1,npcoef
        zlhs(i) = 0.0D00
        zcoef(i) = 0.0D00
        szcoef(i) = 0.0D00
        DO j=1,npcoef
          zrhs(i,j) = 0.0D00
        ENDDO
      ENDDO
      chisq = 0.0D00
c
c...Accumulation
c
      DO i=1,nps
        x = xps(i)
        y = yps(i)
        z = iz(idx(i))
        CALL fillpdv(x,y)
        DO j=1,npcoef
          zlhs(j) = zlhs(j) + pdv(j)*z
          DO k=1,npcoef
            zrhs(j,k) = zrhs(j,k) + pdv(j)*pdv(k)
          ENDDO
        ENDDO
      ENDDO
c
c...Inversion
c
      CALL matinv(ising)
      IF (ising.ne.0) THEN
        WRITE (*,9001)
        CALL EXIT
      ENDIF
c
c...Coefficients
c
      DO i=1,npcoef
        DO j=1,npcoef
          zcoef(i) = zcoef(i) + zrhs(i,j)*zlhs(j)
        ENDDO
      ENDDO
c
c...Residuals And ChiSquared
c
      DO i=1,nps
        x = xps(i)
        y = yps(i)
        z = iz(idx(i))
        CALL fillpdv(x,y)
        zc = 0.0D00
        DO j=1,npcoef
          zc = zc + pdv(j)*zcoef(j)
        ENDDO
        zr = z-zc
        chisq = chisq + zr*zr
      ENDDO
c
c...Error Estimates
c
      ez = SQRT(chisq/(nps-(npcoef+1)))
      DO i=1,npcoef
        szcoef(i) = ez*SQRT(zrhs(i,i))
      ENDDO
      RETURN
      END
