      PROGRAM  followup
c
c...Look At Special Cases
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         nmax = 2000,
     *         nqmax = 100,
     *         drmax = 5*15*100,
     *         testmag = 15.1D00
      INTEGER
     *         ncase, catid(NMAX), npair(NMAX), catx(NMAX),
     *         caty(NMAX), scan(NQMAX,NMAX), starid(NQMAX,NMAX),
     *         i, j, k, l, m, n, case, dx, dy, dr, nhist(NQMAX),
     *         hit, miss1, miss2, rawhist(NQMAX), rawhit, nfaint,
     *         nstar, ngal, nsg, nscan, nkeep
      DOUBLE PRECISION
     *         ra(NQMAX,NMAX), dec(NQMAX,NMAX), mag(NQMAX,NMAX),
     *         x, y, z, sx, sxx, sn, sy, syy, sm, smm, rely1, rely2
c
 9001 FORMAT (2i10, 2i12)
 9002 FORMAT (2i10, f12.2, f12.1, f10.3)
 9003 FORMAT (' Merging Close Pair IDs: ', 2i10)
 9004 FORMAT (' ID=', i6, ' Is Too Faint (', f5.2, '+/-', f4.2, ')')
 9005 FORMAT (' Final Histogram')
 9006 FORMAT (' (', i2, ') N(raw)=', i6, '  N(final)=', i6)
 9007 FORMAT (2i8, 6f10.0)
 9008 FORMAT (' Hit=', i6, '  Miss(1)=', i6, '  Rely(1)=', f7.4,
     * '  Miss(2)=', i6, '  Rely(2)=', f7.4)
 9009 FORMAT (' Raw Statistics:')
 9010 FORMAT (' Clean Statistics: ')
 9011 FORMAT (' Removed ', i4, ' Stars Fainter Than ', f5.2)
 9012 FORMAT (' ', i4, ' Problem Stars In Final Catalog')
 9013 FORMAT (' CatID=', i6, '  N(Star)=', i2, '  N(Gal)=', i2)
 9014 FORMAT (i6, ' Objects With Both Star And Galaxy IDs')
c
c...Open Files And Initialize
c
  100 OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='followup.out',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9001) nkeep
      nscan = nkeep+1
      ncase = 0
      DO i=1,nscan
        rawhist(i) = 0
      ENDDO
c
c...Read Next Entry
c
  110 READ (1,9001,end=120) i,j,k,l
      ncase = ncase+1
      catid(ncase) = i
      npair(ncase) = j
      catx(ncase) = k
      caty(ncase) = l
      rawhist(j) = rawhist(j)+1
      DO i=1,npair(ncase)
        READ (1,9002) scan(i,ncase),starid(i,ncase),ra(i,ncase),
     *                dec(i,ncase),mag(i,ncase)
      ENDDO
      GO TO 110
  120 CLOSE (1)
c
c...Process Each Instance.
c
      nfaint = 0
      nsg = 0
      DO case=1,ncase
        IF (npair(case).gt.0) THEN
c
c...Look For Close Pairs
c
          DO i=1,ncase
            IF ((i.ne.case).and.(npair(case).gt.0)) THEN
              dx = ABS(catx(i)-catx(case))
              IF (dx.le.DRMAX) THEN
                dy = ABS(caty(i)-caty(case))
                IF (dy.le.DRMAX) THEN
                  x = dx
                  y = dy
                  dr = SQRT(x*x+y*y)
                  IF (dr.le.DRMAX) THEN
                    IF ((npair(case)+npair(i)).gt.nscan) GO TO 130
                    DO j=1,npair(case)
                      DO k=1,npair(i)
                        IF (starid(j,case).eq.starid(k,i)) GO TO 130
                      ENDDO
                    ENDDO
                    j = npair(case)
                    DO k=1,npair(i)
                      j = j+1
                      scan(j,case) = scan(k,i)
                      starid(j,case) = starid(k,i)
                      ra(j,case) = ra(k,i)
                      dec(j,case) = dec(k,i)
                      mag(j,case) = mag(k,i)
                    ENDDO
                    npair(case) = npair(case)+npair(i)
                    npair(i) = 0
                    WRITE (*,9003) catid(case),catid(i)
  130               CONTINUE
                  ENDIF
                ENDIF
              ENDIF
            ENDIF
          ENDDO
c
c...Compute Mean Magnitude And See If It Is Too Faint
c
          sx = 0.0D00
          sxx = 0.0D00
          sn = 0.0D00
          DO i=1,npair(case)
            IF (starid(i,case).lt.400000) THEN
              x = mag(i,case)
              sx = sx + x
              sxx = sxx + x*x
              sn = sn + 1.0D00
            ENDIF
          ENDDO
          sx = sx/MAX(sn,1.0D00)
          IF (sn.le.1.0D00) THEN
            sxx = 0.0D00
          ELSE
            sxx = SQRT(sxx/sn - sx*sx)
          ENDIF
          IF (sx.gt.TESTMAG) THEN
            nfaint = nfaint+1
            npair(case) = 0
          ENDIF
c
c...Look For Stars And Galaxies With The Same ID
c
          IF (npair(case).gt.0) THEN
            nstar = 0
            ngal = 0
            DO i=1,npair(case)
              IF (starid(i,case).lt.400000) THEN
                nstar = nstar+1
              ELSE
                ngal = ngal+1
              ENDIF
            ENDDO
            IF ((nstar.ne.0).and.(ngal.ne.0)) THEN
              nsg = nsg+1
              WRITE (*,9013) catid(case),nstar,ngal
            ENDIF
          ENDIF
c
c...End Of Processing Loop
c
        ENDIF
      ENDDO
      WRITE (*,9011) nfaint,TESTMAG
      WRITE (*,9014) nsg
c
c...Compute Corrected Histogram
c
      DO i=1,nscan
        nhist(i) = 0
      ENDDO
      DO i=1,ncase
        IF (npair(i).gt.0) THEN
          j = npair(i)
          nhist(j) = nhist(j)+1
        ENDIF
      ENDDO
      WRITE (*,9005)
      DO i=1,nkeep
        WRITE (*,9006) i,rawhist(i),nhist(i)
      ENDDO
      j = 0
      DO i=1,nkeep
        j = j+nhist(i)
      ENDDO
      WRITE (*,9012) j
c
c...Read SUMMARY.OUT To Find The Number Of HITS
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='summary.out',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      hit = 0
      rawhit = 0
  140 READ (1,9007,end=150) i,j,sx,sxx,sy,syy,sm,smm
      IF (sm.le.TESTMAG) THEN
        hit = hit+1
      ENDIF
      rawhit = rawhit+1
      GO TO 140
  150 CLOSE (1)
c
c...Compute Raw Completeness
c
      WRITE (*,9009)
      miss1 = 0
      DO i=1,nkeep
        miss1 = miss1 + rawhist(i)*(nscan-i)
      ENDDO
      miss2 = miss1 - rawhist(1)*(nscan-1)
      x = rawhit*nscan
      y = rawhit*nscan+miss1
      rely1 = x/y
      y = rawhit*nscan+miss2
      rely2 = x/y
      WRITE (*,9008) rawhit,miss1,rely1,miss2,rely2
c
c...Compute Clean Completeness
c
      WRITE (*,9010)
      miss1 = 0
      DO i=1,nkeep
        miss1 = miss1 + nhist(i)*(nscan-i)
      ENDDO
      miss2 = miss1 - nhist(1)*(nscan-1)
      x = hit*nscan
      y = hit*nscan+miss1
      rely1 = x/y
      y = hit*nscan+miss2
      rely2 = x/y
      WRITE (*,9008) hit,miss1,rely1,miss2,rely2
c
c...Save Clean Version
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='followup.clean',
     *      status='unknown',
     *      unit=1
     *     )
      DO i=1,ncase
        IF ((npair(i).gt.0).and.(npair(i).lt.nscan)) THEN
          WRITE (1,9001) catid(i),npair(i),catx(i),caty(i)
          DO j=1,npair(i)
            WRITE (1,9002) scan(j,i),starid(j,i),ra(j,i),dec(j,i),
     *                     mag(j,i)
          ENDDO
        ENDIF
      ENDDO
      CLOSE (1)
      CALL EXIT
      END
