      SUBROUTINE  gencoef(i1,i2)
c
c...Scribble Astrometric Coefficients
c
      INCLUDE
     *            'coma.inc'
      PARAMETER
     *            xyscale = SCALE*67.18D00/(1000.0D00*100.0D00)
      INTEGER
     *            i1, i2, i, n
      DOUBLE PRECISION
     *            x0, y0, sx, sy, s1, ss1, s2, ss2, s3, ss3, s4, ss4
c
 9001 FORMAT (i2, 2f10.2, 2f10.6)
 9002 FORMAT (' DX=', f10.2, '+/-', f10.2, '   DY=', f10.2, '+/-',
     *        f10.2)
 9003 FORMAT (' SX=', f10.6, '+/-', f10.6, '   SY=', f10.6, '+/-',
     *        f10.6)
c
  100 OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='coef.out',
     *      status='unknown',
     *      unit=1
     *     )
      s1 = 0.0D00
      s2 = 0.0D00
      s3 = 0.0D00
      s4 = 0.0D00
      ss1 = 0.0D00
      ss2 = 0.0D00
      ss3 = 0.0D00
      ss4 = 0.0D00
      n = 0
      DO i=i1,i2
        IF (ncoef(i).gt.0) THEN
          x0 = xcoef(1,i)*XYSCALE
          y0 = ycoef(1,i)*XYSCALE
          sx = xcoef(2,i)
          sy = ycoef(3,i)
          WRITE (1,9001) i,x0,y0,sx,sy
          s1 = s1 + x0
          ss1 = ss1 + x0*x0
          s2 = s2 + y0
          ss2 = ss2 + y0*y0
          s3 = s3 + sx
          ss3 = ss3 + sx*sx
          s4 = s4 + sy
          ss4 = ss4 + sy*sy
          n = n+1
        ENDIF
      ENDDO
      CLOSE (1)
      s1 = s1/n
      ss1 = SQRT(ss1/n - s1*s1)
      s2 = s2/n
      ss2 = SQRT(ss2/n - s2*s2)
      s3 = s3/n
      ss3 = SQRT(ss3/n - s3*s3)
      s4 = s4/n
      ss4 = SQRT(ss4/n - s4*s4)
      WRITE (*,9002) s1,ss1,s2,ss2
      WRITE (*,9003) s3,ss3,s4,ss4
      RETURN
      END
