      SUBROUTINE  summary(i1,i2)
c
c...Look Through Matches And Compute Various Things
c
      INCLUDE
     *             'coma.inc'
      PARAMETER
     *             xyscale = (0.01D00*67.18D00/1000.0D00),
     *             mscale = 0.01D00
      INTEGER
     *             i, j, n, i1, i2, q(NQMAX), hit, miss
      DOUBLE PRECISION
     *             sx, sxx, sy, syy, sm, smm, x, y, m, success
c
 9001 FORMAT (' N(hit)=', i6, '  N(miss0)=', i6, '  Success=', f6.4)
 9002 FORMAT (' N(hit)=', i6, '  N(miss1)=', i6, '  Success=', f6.4)
c
c...Outer Loop Over (2) Stars (==Fixed Catalog)
c
      open (access='sequential',carriagecontrol='list',dispose='keep',
     * form='formatted',name='summary.out',status='unknown',unit=1)
  100 DO j=1,NMAX
        n = 0
        sx = 0.0D00
        sxx = 0.0D00
        sy = 0.0D00
        syy = 0.0D00
        sm = 0.0D00
        smm = 0.0D00
c
c...Inner Loop Over Observations
c
        DO i=i1,i2
          IF (index(i,j).gt.0) THEN
c
c...This Pair Was Seen
c
            x = XYSCALE*xres(i,j)
            y = XYSCALE*yres(i,j)
            m = MSCALE*mres(i,j)
            sx = sx + x
            sxx = sxx + x*x
            sy = sy + y
            syy = syy + y*y
            sm = sm + m
            smm = smm + m*m
            n = n+1
            q(n) = i
          ENDIF
        ENDDO
        nper(j) = n
c
c...Compute Statistics
c
        IF (n.gt.0) THEN
          sx = sx/n
          sy = sy/n
          sm = sm/n
          IF (n.le.1) THEN
            sxx = 0.0D00
            syy = 0.0D00
            smm = 0.0D00
          ELSE
            sxx = SQRT(sxx/n - sx*sx)
            syy = SQRT(syy/n - sy*sy)
            smm = SQRT(smm/n - sm*sm)
          ENDIF
          nhist(n) = nhist(n)+1
      write (1,9991) j,n,sx,sxx,sy,syy,sm,smm
 9991 format (2i8, 6f10.2, 10i3)
        ENDIF
      ENDDO
      close (1)
c
c...Look At The Histogram And Compute Hits And Misses
c
      n = 0
      y = 0.0D00
      DO i=1,(i2+1-i1)
        y = y+nhist(i)
        IF (nhist(i).gt.0) THEN
          n = i
        ENDIF
      ENDDO
      DO i=1,n
        x = nhist(i)
        m = 100.0D00*x/y
        write (*,9992) i,nhist(i),m
      ENDDO
 9992 format (2i6, f10.1)
      hit = n*nhist(n)
      miss = 0
      DO i=1,n-1
        miss = miss + (n-1)*nhist(i)
      ENDDO
      success = hit+miss
      success = hit/success
      WRITE (*,9001) hit,miss,success
      miss = 0
      DO i=2,n-1
        miss = miss + (n-1)*nhist(i)
      ENDDO
      success = hit+miss
      success = hit/success
      WRITE (*,9002) hit,miss,success
      RETURN
      END
