      SUBROUTINE  adump
c
c...Dump The B List
c
      INCLUDE
     *            'genover.inc'
      INTEGER
     *            nframe, i, low, high
      DOUBLE PRECISION
     *            x, y, mra, mdec
 9003 FORMAT (2i10, 3x, 'GENOVER', 2f10.6)
 9004 FORMAT (4(1x,1pe20.10))
c
c...Open The INF File
c
  100 OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name=aname(1:naname)//'.inf',
     *      status='unknown',
     *      unit=1
     *     )
      nframe = 1
      mra = field_mra/ra_to_rad
      mdec = field_mdec/dec_to_rad
      WRITE (1,9003) na,nframe,mra,mdec
      x = 0.0D00
      y = 1.0D00
      WRITE (1,9004) x,y
      i = 1
      x = 1.0D00
      y = 1.0D00
      WRITE (1,9003) i
      WRITE (1,9004) x,y
      WRITE (1,9003) i,i
      WRITE (1,9004) x
      WRITE (1,9004) y
      x = 0.0D00
      WRITE (1,9004) x
      CLOSE (1)
c
c...Write The HDR File
c
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='delete',
     *      err=110,
     *      form='unformatted',
     *      name=aname(1:naname)//'.hdr',
     *      recl=(2*nframe),
     *      recordtype='fixed',
     *      status='old',
     *      unit=1
     *     )
      CLOSE (1)
  110 OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      form='unformatted',
     *      name=aname(1:naname)//'.hdr',
     *      recl=(2*nframe),
     *      recordtype='fixed',
     *      status='new',
     *      unit=1
     *     )
      x = 0.0D00
      DO i=1,12
        WRITE (1,rec=i) x
      ENDDO
      i = 1
      WRITE (1,rec=13) i,na
      CLOSE (1)
c
c...Open The DAT File
c
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='delete',
     *      err=120,
     *      form='unformatted',
     *      name=aname(1:naname)//'.dat',
     *      recl=na,
     *      recordtype='fixed',
     *      status='old',
     *      unit=1
     *     )
      CLOSE (1)
  120 OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      form='unformatted',
     *      name=aname(1:naname)//'.dat',
     *      recl=na,
     *      recordtype='fixed',
     *      status='new',
     *      unit=1
     *     )
c
c...Fill TMP With 0s and IDX With MAG/MAG
c
      DO i=1,na
        low = amag(i)
        high = amag(i)
        idx(i) = 10000*high + low
        tmp(i) = 0
      ENDDO
      WRITE (1,rec= 1) ( aid(i),i=1,na)
      WRITE (1,rec= 2) ( tmp(i),i=1,na)
      WRITE (1,rec= 3) ( tmp(i),i=1,na)
      WRITE (1,rec= 4) ( idx(i),i=1,na)
      WRITE (1,rec= 5) ( tmp(i),i=1,na)
      WRITE (1,rec= 6) ( tmp(i),i=1,na)
      WRITE (1,rec= 7) ( tmp(i),i=1,na)
      WRITE (1,rec= 8) ( tmp(i),i=1,na)
      WRITE (1,rec= 9) ( ara(i),i=1,na)
      WRITE (1,rec=10) (adec(i),i=1,na)
      WRITE (1,rec=11) ( tmp(i),i=1,na)
      WRITE (1,rec=12) ( tmp(i),i=1,na)
      WRITE (1,rec=13) ( tmp(i),i=1,na)
      CLOSE (1)
      RETURN
      END
