      SUBROUTINE  psfit(iz,zcoef,szcoef,ez)
c
c...Fit PS to Projected P.PS_S Coordinates
c
      INCLUDE
     *            'genover.inc'
      DOUBLE PRECISION
     *            x, y, z, ez, chisq, zcoef(*), szcoef(*), zc, zr
      INTEGER
     *            i, j, k, ising, iz(*)
c
 9001 FORMAT (' Singular Matrix In PSFIT')
c
c...Initialization
c
  100 DO i=1,ncoef
        zlhs(i) = 0.0D00
        zcoef(i) = 0.0D00
        szcoef(i) = 0.0D00
        DO j=1,ncoef
          zrhs(i,j) = 0.0D00
        ENDDO
      ENDDO
      chisq = 0.0D00
c
c...Accumulation
c
      DO i=1,nps
        x = xps(i)
        y = yps(i)
        z = iz(idx(i))
        CALL filldv(x,y)
        DO j=1,ncoef
          zlhs(j) = zlhs(j) + dv(j)*z
          DO k=1,ncoef
            zrhs(j,k) = zrhs(j,k) + dv(j)*dv(k)
          ENDDO
        ENDDO
      ENDDO
c
c...Inversion
c
      CALL matinv(ising)
      IF (ising.ne.0) THEN
        WRITE (*,9001)
        CALL EXIT
      ENDIF
c
c...Coefficients
c
      DO i=1,ncoef
        DO j=1,ncoef
          zcoef(i) = zcoef(i) + zrhs(i,j)*zlhs(j)
        ENDDO
      ENDDO
c
c...Residuals And ChiSquared
c
      DO i=1,nps
        x = xps(i)
        y = yps(i)
        z = iz(idx(i))
        CALL filldv(x,y)
        zc = 0.0D00
        DO j=1,ncoef
          zc = zc + dv(j)*zcoef(j)
        ENDDO
        zr = z-zc
        chisq = chisq + zr*zr
      ENDDO
c
c...Error Estimates
c
      ez = SQRT(chisq/(nps-(ncoef+1)))
      DO i=1,ncoef
        szcoef(i) = ez*SQRT(zrhs(i,i))
      ENDDO
      RETURN
      END
