      SUBROUTINE  agobble
c
c...Recover UJ Catalog Piece(s) That Covers B List
c
      INCLUDE
     *         'genover.inc'
      INTEGER
     *         rmin, rmax, dmin, dmax, nq, qrmin(4), qrmax(4),
     *         qdmin(4), qdmax(4), i, eps, s, nlb
      DOUBLE PRECISION
     *         d, x1, x2, y1, y2
      CHARACTER*64
     *         lb
      CHARACTER*1
     *         c
c
 9001 FORMAT (' NA=', i6)
 9002 FORMAT (' Enter IRD File Root (SSxxxx)(Null=Done): ' $)
 9003 FORMAT (q, a)
 9004 FORMAT (' Search RA(', f6.3, ',', f6.3, ')  Dec(', f7.3, ',',
     *        f7.3, ')')
c
c...Get Limits From B
c
  100 dmin = bdec(1)
      dmax = dmin
      rmin = bra(1)
      rmax = rmin
      DO i=2,nb
        dmin = MIN(dmin,bdec(i))
        dmax = MAX(dmax,bdec(i))
        rmin = MIN(rmin,bra(i))
        rmax = MAX(rmax,bra(i))
      ENDDO
c
c...Pad To Allow For Error Radius
c
      d = MAX(ABS(dmin-DOFFSET),ABS(dmax-DOFFSET))/DDFACTOR
      eps = 100.0D00*radius/COSD(d)
      IF ((rmax-rmin).lt.HALF_CIRCLE) THEN
        field_mra = ((rmax+rmin+1)/2)/DRFACTOR
        field_mdec = (((dmax+dmin+1)/2)-DDOFFSET)/DDFACTOR
        rmin = rmin-eps
        IF (rmin.lt.0) THEN
          rmin = rmin+CIRCLE
        ENDIF
        rmax = rmax+eps
        IF (rmax.ge.CIRCLE) THEN
          rmax = rmax-CIRCLE
        ENDIF
      ELSE
        field_mra = ((rmax+rmin+1-CIRCLE)/2)/DRFACTOR
        IF (field_mra.lt.0.0D00) THEN
          field_mra = field_mra + 24.0D00
        ENDIF
        field_mdec = (((dmax+dmin+1)/2)-DDOFFSET)/DDFACTOR
        rmin = rmin+eps
        rmax = rmax-eps
      ENDIF
      dmin = dmin-eps
      dmax = dmax+eps
c
c...Tell The User
c
      x1 = rmin/DRFACTOR
      x2 = rmax/DRFACTOR
      y1 = (dmin-DDOFFSET)/DDFACTOR
      y2 = (dmax-DDOFFSET)/DDFACTOR
      WRITE (*,9004) x1,x2,y1,y2
c
c...Does Search Cross The 24-Hour Boundary
c
      IF ((rmax-rmin).lt.HALF_CIRCLE) THEN
        nq = 1
        qrmin(1) = rmin
        qrmax(1) = rmax
      ELSE
        nq = 2
        qrmin(1) = 0
        qrmax(1) = rmin
        qrmin(2) = rmax
        qrmax(2) = CIRCLE-1
      ENDIF
      DO i=1,nq
        qdmin(i) = dmin
        qdmax(i) = dmax
      ENDDO
c
c..Prompt For One Or More IRD Files
c
      na = 0
  110 WRITE (*,9002)
      READ  (*,9003,err=110,end=200) nlb,lb
      IF (nlb.gt.0) THEN
        IF (nlb.ne.6) GO TO 110
        DO i=1,nlb
          c = lb(i:i)
          IF ((c.ge.'A').and.(c.le.'Z')) THEN
            c = CHAR(ICHAR(c)+32)
          ENDIF
          lb(i:i) = c
        ENDDO
        CALL irdread(lb(1:nlb),nq,qrmin,qrmax,qdmin,qdmax)
        WRITE (*,9001) na
        survey = lb(1:2)
        GO TO 110
      ENDIF
      IF (na.le.10) GO TO 200
      RETURN
c
c...Some Fatal Error
c
  200 CALL EXIT
      END
