      SUBROUTINE  bkgobble
c
c...Fill BK List
c
      INCLUDE
     *            'genover.inc'
      INTEGER
     *            nlb, ntb, id, i
      DOUBLE PRECISION
     *            rhh, rmm, rss, ddd, dmm, dss, mag,
     *            r2000, d2000, r1950, d1950, epoch
      CHARACTER*64
     *            lb, tb
c
 9002 FORMAT (q, a)
 9003 FORMAT (' Cannot Open ', a)
 9004 FORMAT (i6, 1x, 2f2.0,f5.2, 2x, 2f2.0,f4.1, 3x, f6.3)
 9005 FORMAT (' NBK=', i6)
 9006 FORMAT (' Error Parsing >>', a, '<<')
c
c...Get File And Open It
c
  100 CALL f_doenv('DGM:'//root(1:nroot)//'k',nlb,lb)
      nbk = 0
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=200,
     *      form='formatted',
     *      name=lb(1:nlb),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      DO i=1,3
        READ (1,9002)
      ENDDO
c
c...Ingest The File And Convert To UJ Integers
c
  110 READ (1,9002,err=110,end=130) nlb,lb
      READ (lb(1:nlb),9004,err=120) id,rhh,rmm,rss,ddd,dmm,dss,mag
      r1950 = rhh + rmm/60.0D00 + rss/3600.0D00
      d1950 = ABS(ddd) + dmm/60.0D00 + dss/3600.0D00
      IF (INDEX(lb(17:20),'-').gt.0) THEN
        d1950 = -d1950
      ENDIF
      r1950 = r1950*ra_to_rad
      d1950 = d1950*dec_to_rad
      epoch = 1995.5D00
      CALL sla_FK45Z(r1950,d1950,epoch,r2000,d2000)
      r2000 = r2000/ra_to_rad
      d2000 = d2000/dec_to_rad
      nbk = nbk+1
      bkid(nbk) = id
      bkra(nbk) = r2000*DRFACTOR + 0.5D00
      bkdec(nbk) = d2000*DDFACTOR + DOFFSET + 0.5D00
      bkmag(nbk) = mag*DMFACTOR + 0.5D00
      GO TO 110
  120 WRITE (*,9006) lb(1:nlb)
      GO TO 110
c
c...All Done.
c
  130 CLOSE (1)
      WRITE (*,9005) nbk
      RETURN
c
c...Errors
c
  200 WRITE (*,9003) lb(1:nlb)
      RETURN
      END
