      PROGRAM  check
c
c...Make Sure We Made The Catalog Properly
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         ncmax = (100*1000),
     *         nsmax = (5*1000*1000),
     *         nfmax = 1000
      INTEGER
     *         nc, cf(NCMAX), ci(NCMAX), nlb, cr(NCMAX), cd(NCMAX),
     *         i, field(NFMAX), j, n, C_GENLEN, rr(NSMAX), dd(NSMAX),
     *         r1, r2, d1, d2, nok, nfail, ntb
      CHARACTER*64
     *         lb, tb
      BYTE
     *         bb(65)
c
 9001 FORMAT (i10)
 9002 FORMAT (' NC=', i10)
 9003 FORMAT ('SFIRD:sf', i4.4, '.ird')
 9004 FORMAT ('N(IRD)=', i10)
 9005 FORMAT (' F=', i3, '  N(OK)=', i6, '  N(Fail)=', i6)
c
c...Read The Catalog
c
  100 lb = '/uz6/xpmm/aux2mass/sfsa57a.inf'
      nlb = 30
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name=lb(1:nlb),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9001) nc
      CLOSE (1)
      DO i=1,NFMAX
        field(i) = 0
      ENDDO
      lb(nlb-2:nlb) = 'dat'
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      form='unformatted',
     *      name=lb(1:nlb),
     *      readonly,
     *      recl=nc,
     *      recordtype='fixed',
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,rec= 1) (ci(i),i=1,nc)
      READ (1,rec= 2) (cf(i),i=1,nc)
      READ (1,rec=12) (cr(i),i=1,nc)
      READ (1,rec=13) (cd(i),i=1,nc)
      CLOSE (1)
      DO i=1,nc
        field(cf(i)) = 1
      ENDDO
      WRITE (*,9002) nc
c
c...Process Each Field
c
      DO i=1,NFMAX
        IF (field(i).ne.0) THEN
          WRITE (tb,9003) i
          ntb = 16
          CALL f_doenv(tb(1:ntb),nlb,lb)
          DO j=1,nlb
            bb(j) = ICHAR(lb(j:j))
          ENDDO
          bb(nlb+1) = 0
          n = C_GENLEN(bb)
          IF (n.le.0) GO TO 110
          n = n/8
          OPEN (
     *          access='direct',
     *          carriagecontrol='none',
     *          convert='big_endian',
     *          dispose='keep',
     *          form='unformatted',
     *          name=lb(1:nlb),
     *          readonly,
     *          recl=n,
     *          recordtype='fixed',
     *          shared,
     *          status='old',
     *          unit=1
     *         )
          READ (1,rec=1) (rr(j),j=1,n)
          READ (1,rec=2) (dd(j),j=1,n)
          CLOSE (1)
          WRITE (*,9004) n
          nok = 0
          nfail = 0
          DO j=1,nc
            IF (cf(j).eq.i) THEN
              r1 = cr(j)
              d1 = cd(j)
              r2 = rr(ci(j))
              d2 = dd(ci(j))
              IF ((r1.eq.r2).and.(d1.eq.d2)) THEN
                nok = nok+1
              ELSE
                nfail = nfail+1
              ENDIF
            ENDIF
          ENDDO
          WRITE (*,9005) i,nok,nfail
  110     CONTINUE
        ENDIF
      ENDDO
c
c...All Done
c
      CALL EXIT
      END
