      SUBROUTINE  agobble
c
c...Recover UJ Catalog Piece(s) That Covers B List
c
      INCLUDE
     *         'genover.inc'
      INTEGER
     *         rmin, rmax, dmin, dmax, nq, qrmin(4), qrmax(4),
     *         qdmin(4), qdmax(4), smin, smax, i, eps, s
      DOUBLE PRECISION
     *         d, x1, x2, y1, y2
c
 9001 FORMAT (' NA=', i6)
 9002 FORMAT (' UJ Read Fails With NA=', i6)
 9003 FORMAT (' Search RA(', f6.3, ',', f6.3, ')  Dec(', f7.3, ',',
     *        f7.3, ')')
c
c...Get Limits From B
c
  100 dmin = bdec(1)
      dmax = dmin
      rmin = bra(1)
      rmax = rmin
      DO i=2,nb
        dmin = MIN(dmin,bdec(i))
        dmax = MAX(dmax,bdec(i))
        rmin = MIN(rmin,bra(i))
        rmax = MAX(rmax,bra(i))
      ENDDO
c
c...Pad To Allow For Error Radius
c
      d = MAX(ABS(dmin-DOFFSET),ABS(dmax-DOFFSET))/DDFACTOR
      eps = 100.0D00*radius/COSD(d)
      IF ((rmax-rmin).lt.HALF_CIRCLE) THEN
        field_mra = ((rmax+rmin+1)/2)/DRFACTOR
        field_mdec = (((dmax+dmin+1)/2)-DDOFFSET)/DDFACTOR
        rmin = rmin-eps
        IF (rmin.lt.0) THEN
          rmin = rmin+CIRCLE
        ENDIF
        rmax = rmax+eps
        IF (rmax.ge.CIRCLE) THEN
          rmax = rmax-CIRCLE
        ENDIF
      ELSE
        field_mra = ((rmax+rmin+1-CIRCLE)/2)/DRFACTOR
        IF (field_mra.lt.0.0D00) THEN
          field_mra = field_mra + 24.0D00
        ENDIF
        field_mdec = (((dmax+dmin+1)/2)-DDOFFSET)/DDFACTOR
        rmin = rmin+eps
        rmax = rmax-eps
      ENDIF
      dmin = dmin-eps
      dmax = dmax+eps
      smin = ((10*dmin)/DFACTOR)/75
      smin = smin*75
      smax = ((10*dmax)/DFACTOR)/75
      smax = smax*75
c
c...Tell User
c
      x1 = rmin/DRFACTOR
      x2 = rmax/DRFACTOR
      y1 = (dmin-DDOFFSET)/DDFACTOR
      y2 = (dmax-DDOFFSET)/DDFACTOR
      WRITE (*,9003) x1,x2,y1,y2
c
c...Single Zone Search
c
      IF (smin.eq.smax) THEN
        IF ((rmax-rmin).lt.HALF_CIRCLE) THEN
          nq = 1
          qrmin(1) = rmin
          qrmax(1) = rmax
        ELSE
          nq = 2
          qrmin(1) = 0
          qrmax(1) = rmin
          qrmin(2) = rmax
          qrmax(2) = CIRCLE-1
        ENDIF
        DO i=1,nq
          qdmin(i) = dmin
          qdmax(i) = dmax
        ENDDO
c
c...Double Zone Search
c
      ELSE
        s = (smax*DFACTOR)/10
        IF ((rmax-rmin).lt.HALF_CIRCLE) THEN
          nq = 2
          DO i=1,nq
            qrmin(i) = rmin
            qrmax(i) = rmax
          ENDDO
          qdmin(1) = dmin
          qdmax(1) = s-1
          qdmin(2) = s
          qdmax(2) = dmax
        ELSE
          nq = 4
          DO i=1,3,2
            qrmin(i) = 0
            qrmax(i) = rmin
          ENDDO
          DO i=2,4,2
            qrmin(i) = rmax
            qrmax(i) = CIRCLE-1
          ENDDO
          DO i=1,2
            qdmin(i) = dmin
            qdmax(i) = s-1
          ENDDO
          DO i=3,4
            qdmin(i) = s
            qdmax(i) = dmax
          ENDDO
        ENDIF
      ENDIF
c
c...Call UJ Reader
c
      na = 0
      DO i=1,nq
        CALL ujread(qrmin(i),qrmax(i),qdmin(i),qdmax(i))
      ENDDO
      IF (na.le.10) THEN
        WRITE (*,9002) na
        CALL EXIT
      ENDIF
      WRITE (*,9001) na
      RETURN
      END
