      SUBROUTINE  ujread(ramin,ramax,decmin,decmax)
c
c...Look In UJ
c
      INCLUDE
     *            'genover.inc'
      PARAMETER
     *            hfactor = (RFACTOR/4),
     *            nfieldmax = 20
      INTEGER
     *            ramin, ramax, decmin, decmax, zone, nroot, i,
     *            hfrst, hlast, offset, total, buf(3), ra, dec, mag,
     *            ident(NFIELDMAX), number(NFIELDMAX), f, j, nfield
      CHARACTER*64
     *            root
      EQUIVALENCE
     *            (buf(1),ra), (buf(2),dec), (buf(3),mag)
c
 9001 FORMAT ('/uz6/xpmm/merges/zone', i4.4, '.acc')
 9002 FORMAT (' Fatal UJ Error ', a)
 9003 FORMAT (f5.2, 2i12)
 9004 FORMAT (' Field ', i3, ' Yielded ', i6, ' Stars.')
c
c...Load Accelerator File Only If Zone Has Changed
c
  100 zone = ((10*decmin)/DFACTOR)/75
      zone = zone*75
      WRITE (root,9001) zone
      nroot = 29
      IF (zone.ne.ujzone) THEN
        OPEN (
     *        access='sequential',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        err=200,
     *        form='formatted',
     *        name=root(1:nroot),
     *        readonly,
     *        shared,
     *        status='old',
     *        unit=1
     *       )
        DO i=1,96
          READ (1,9003) ujra(i),ujstart(i),ujlength(i)
        ENDDO
        CLOSE (1)
        ujzone = zone
      ENDIF
c
c...Easy To Code But Slow To Use
c
      hfrst = (ramin/HFACTOR) + 1
      hlast = (ramax/HFACTOR) + 1
      offset = ujstart(hfrst)-1
      total = 0
      DO i=hfrst,hlast
        total = total + ujlength(i)
      ENDDO
      root(nroot-2:nroot) = 'cat'
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      err=200,
     *      form='unformatted',
     *      name=root(1:nroot),
     *      readonly,
     *      recl=3,
     *      recordtype='fixed',
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      nfield = 0
      DO i=1,total
        offset = offset+1
        READ (1,rec=offset) buf
        IF (mag.gt.0) THEN
          IF (ra.ge.ramin) THEN
            IF (ra.le.ramax) THEN
              IF ((dec.ge.decmin).and.(dec.le.decmax)) THEN
                na = na+1
                aid(na) = offset
                ara(na) = ra
                adec(na) = dec
                amag(na) = MOD(mag,10000)
                f = mag/10000
                f = MOD(f,1000)
                DO j=1,nfield
                  IF (f.eq.ident(j)) THEN
                    number(j) = number(j)+1
                    GO TO 105
                  ENDIF
                ENDDO
                nfield = nfield+1
                ident(nfield) = f
                number(nfield) = 1
  105           CONTINUE
              ENDIF
            ELSE
              GO TO 110
            ENDIF
          ENDIF
        ENDIF
      ENDDO
  110 CLOSE (1)
      DO f=1,nfield
        WRITE (*,9004) ident(f),number(f)
      ENDDO
      RETURN
c
c...Serious Error
c
  200 WRITE (*,9002) root(1:nroot)
      CALL EXIT
      END
