      SUBROUTINE altg1
c
c...This routine forms the first guess on the basis of a specified plate.
c
      INCLUDE
     *           'pa6inc1.inc'
      DIMENSION
     *           xnorm(ls), ynorm(ls), xsw(ls), ysw(ls), iwork(ls),
     *           jwork(ls), fit(ls)
      DATA
     *           ihx/1hx/, ihy/1hy/
c
 9001 FORMAT ('0FIRST GUESS FROM PLATE ', I4, ' FOR ', 10A1,
     * ' using plates', 12(1x, i3))
 9002 FORMAT (' GUESS PLATE ', I4, ' / ', 10A1, 12(1X, I3))
 9003 FORMAT (' GUESS STDERX=', f10.3, '   STDERY=', f10.3)
c
c...Assign Mean Positions For Stars With Valid Measurements
c
  100 DO istar=1,nstar
        IF  ((xcoord(istar,ipick).ne.TAG)
     *  .and.(ycoord(istar,ipick).ne.TAG)) THEN
          xcalc(istar,ipick) = xcoord(istar,ipick)
          ycalc(istar,ipick) = ycoord(istar,ipick)
          xbar(istar) = xcoord(istar,ipick)
          ybar(istar) = ycoord(istar,ipick)
          xresid(istar,ipick) = 0.0
          yresid(istar,ipick) = 0.0
          xsig(istar) = 0.0
          ysig(istar) = 0.0
        ELSE
          xcalc(istar,ipick) = TAG
          ycalc(istar,ipick) = TAG
          xbar(istar) = TAG
          ybar(istar) = TAG
          xresid(istar,ipick) = TAG
          yresid(istar,ipick) = TAG
          xsig(istar) = TAG
          ysig(istar) = TAG
        ENDIF
      ENDDO
c
c...Outer Loop Process All Plates Other Than IPICK
c
      DO iplate=1,nplate
        IF (iplate.ne.ipick) THEN
c
c...X Solution.  NOTE: XBAR May Be Missing On IPICK
c
          ico = 1
          IF (inxfit(1,iplate).eq.0) ico=0
          DO i=2,lc
            IF (inxfit(i,iplate).ne.0) ico=0
          ENDDO
          DO i=1,nstar
            IF (ico.eq.0) THEN
              fit(i) = xbar(i)
            ELSE
              IF ((xbar(i).eq.TAG).or.(xcoord(i,iplate).eq.TAG)) THEN
                fit(i) = TAG
              ELSE
                fit(i) = xbar(i)-xcoord(i,iplate)
              ENDIF
            ENDIF
          ENDDO
          CALL pcfit(xcoord(1,iplate),ycoord(1,iplate),abar,acol,fit,
     *               pconx(1,iplate),spconx(1,iplate),sigpcx,nxfit,
     *               inxfit(1,iplate),nofit)
          DO istar=1,nstar
            IF (nofit.eq.1) THEN
              xcalc(istar,iplate) = TAG
              xresid(istar,iplate) = TAG
            ELSE
              x = xcoord(istar,iplate)
              y = ycoord(istar,iplate)
              a = abar(istar)
              c = acol(istar)
              IF ((x.eq.TAG).or.(y.eq.TAG)
     *        .or.(a.eq.TAG).or.(c.eq.TAG)) THEN
                xcalc(istar,iplate) = TAG
                xresid(istar,iplate) = TAG
              ELSE
                CALL evalpc(x,y,a,c,nxfit,inxfit(1,iplate),
     *                    pconx(1,iplate),eval)
                IF (ico.eq.0) THEN
                  xcalc(istar,iplate) = eval
                ELSE
                  xcalc(istar,iplate) = eval+xcoord(istar,iplate)
                ENDIF
                IF (xbar(istar).ne.TAG) THEN
                  xresid(istar,iplate) = xcalc(istar,iplate)-xbar(istar)
                ELSE
                  xresid(istar,iplate) = TAG
                ENDIF
              ENDIF
            ENDIF
          ENDDO
c
c...Y Solution.  NOTE: YBAR May Be Missing On IPICK
c
          ico = 1
          IF (inyfit(1,iplate).eq.0) ico=0
          DO i=2,lc
            IF (inyfit(i,iplate).ne.0) ico=0
          ENDDO
          DO i=1,nstar
            IF (ico.eq.0) THEN
              fit(i) = ybar(i)
            ELSE
              IF ((ybar(i).eq.TAG).or.(ycoord(i,iplate).eq.TAG)) THEN
                fit(i) = TAG
              ELSE
                fit(i) = ybar(i)-ycoord(i,iplate)
              ENDIF
            ENDIF
          ENDDO
          CALL pcfit(xcoord(1,iplate),ycoord(1,iplate),abar,acol,fit,
     *               pcony(1,iplate),spcony(1,iplate),sigpcy,nyfit,
     *               inyfit(1,iplate),nofit)
          DO istar=1,nstar
            IF (nofit.eq.1) THEN
              ycalc(istar,iplate)= TAG
              yresid(istar,iplate)= TAG
            ELSE
              x = xcoord(istar,iplate)
              y = ycoord(istar,iplate)
              a = abar(istar)
              c = acol(istar)
              IF ((x.eq.tag).or.(y.eq.tag)
     *        .or.(a.eq.tag).or.(c.eq.tag)) THEN
                ycalc(istar,iplate) = TAG
                yresid(istar,iplate) = TAG
              ELSE
                CALL evalpc(x,y,a,c,nyfit,inyfit(1,iplate),
     *                    pcony(1,iplate),eval)
                IF (ico.eq.0) THEN
                  ycalc(istar,iplate) = eval
                ELSE
                  ycalc(istar,iplate) = eval+ycoord(istar,iplate)
                ENDIF
                IF (ybar(istar).ne.TAG) THEN
                  yresid(istar,iplate) = ycalc(istar,iplate)-ybar(istar)
                ELSE
                  yresid(istar,iplate) = TAG
                ENDIF
              ENDIF
            ENDIF
          ENDDO
c
c...End Of Plate Loop
        ENDIF
      ENDDO
c
c...Compute Mean Coordinates If They Were Not Assigned From IPICK
c
      DO istar=1,nstar
        IF (xbar(istar).eq.TAG) THEN
          sw = 0.0
          sx = 0.0
          DO iplate=1,nplate
            w = wplate(iplate)
            x = xcalc(istar,iplate)
            IF (x.ne.TAG) THEN
              sw = sw + w
              sx = sx + w*x
            ENDIF
          ENDDO
          IF (sw.gt.0.0) THEN
            xbar(istar) = sx/sw
            DO iplate=1,nplate
              IF (xcalc(istar,iplate).ne.TAG) THEN
                xresid(istar,iplate) = xcalc(istar,iplate)-xbar(istar)
              ENDIF
            ENDDO
          ENDIF
        ENDIF
        IF (ybar(istar).eq.TAG) THEN
          sw = 0.0
          sy = 0.0
          DO iplate=1,nplate
            w = wplate(iplate)
            y = ycalc(istar,iplate)
            IF (y.ne.TAG) THEN
              sw = sw + w
              sy = sy + w*y
            ENDIF
          ENDDO
          IF (sw.gt.0.0) THEN
            ybar(istar) = sy/sw
            DO iplate=1,nplate
              IF (ycalc(istar,iplate).ne.TAG) THEN
                yresid(istar,iplate) = ycalc(istar,iplate)-ybar(istar)
              ENDIF
            ENDDO
          ENDIF
        ENDIF
      ENDDO
c
c...Compute Errors
c
      pw = 0.0
      px = 0.0
      py = 0.0
      DO istar=1,nstar
        sw = 0.0
        sx = 0.0
        sy = 0.0
        DO iplate=1,nplate
          w = wplate(iplate)
          x = xresid(istar,iplate)
          y = yresid(istar,iplate)
          IF ((x.ne.TAG).and.(y.ne.TAG)) THEN
            sw = sw + w
            sx = sx + w*x*x
            sy = sy + w*y*y
            IF (instar(istar).ne.0) THEN
              pw = pw + w
              px = px + w*x*x
              py = py + w*y*y
            ENDIF
          ENDIF
        ENDDO
        IF (sw.gt.0.0) THEN
          xsig(istar) = SQRT(sx/sw)
          ysig(istar) = SQRT(sy/sw)
        ELSE
          xsig(istar) = TAG
          ysig(istar) = TAG
        ENDIF
      ENDDO
      IF (pw.gt.0) THEN
        px = SQRT(px/pw)
        py = SQRT(py/pw)
      ENDIF
c
c...now finish up
c
      WRITE (2,9001,iostat=junk) lookp(ipick),
     * (ititle(i),i=1,lt),(lookp(i),i=1,nplate)
      WRITE (*,9002,iostat=junk) lookp(ipick),
     * (ititle(i),i=1,lt),(lookp(i),i=1,nplate)
c==>      CALL dskout
      CALL outxy
      CALL outpc
      IF (nohclp.eq.0) THEN
        CALL hclip(nstar,xbar,xsig,instar,tag,iwork,jwork,ihx,infrst,
     *             inrest,looks)
        CALL hclip(nstar,ybar,ysig,instar,tag,iwork,jwork,ihy,infrst,
     *             inrest,looks)
      ENDIF
      RETURN
      END
