      PROGRAM  fixscale
c
c...Look At Scales From FOCUS-Type Frames
c
      INCLUDE
     *            'pa6inc1.inc'
      CHARACTER*80
     *            lb
      INTEGER
     *            nlb, iplate, n
      DOUBLE PRECISION
     *            x, y, sx, sy, sz, rx, ry, rz, xscale, yscale
c
 9001 FORMAT (1x, i4, 6f12.8)
c
c...Open The File
c
  100 CALL onlydskin(0)
      CALL dev_ttdoenv('A6FILES:SCALE.LIS',nlb,lb)
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name=lb(1:nlb),
     *      status='unknown',
     *      unit=1
     *     )
c
c...Compute Mean First
c
      n = 0
      sx = 0.0
      sy = 0.0
      DO iplate=1,nplate
        x = SQRT(pconx(2,iplate)**2 + pconx(3,iplate)**2)
        y = SQRT(pcony(2,iplate)**2 + pcony(3,iplate)**2)
        sx = sx + x
        sy = sy + y
        n = n+1
      ENDDO
      xscale = sx/n
      yscale = sy/n
c
c...Accumulate Dispersions
c
      n = 0
      sz = 0.0
      DO iplate=1,nplate
        x = SQRT(pconx(2,iplate)**2 + pconx(3,iplate)**2)
        y = SQRT(pcony(2,iplate)**2 + pcony(3,iplate)**2)
        sx = SQRT(spconx(2,iplate)**2 + spcony(3,iplate)**2)
        sy = SQRT(spcony(2,iplate)**2 + spcony(3,iplate)**2)
        rx = x-xscale
        ry = y-yscale
        sz = sz + rx**2 + ry**2
        n = n+2
        WRITE (1,9001) lookp(iplate),x,y,sx,sy,rx,ry
      ENDDO
c
c...Show Mean
c
      rz = SQRT(sz/n)
      n = 0
      WRITE (*,9001) n,xscale,yscale,rz
c
c...All Done
c
      CLOSE (1)
      CALL EXIT
      END
