      subroutine mpfit(in,mfit,qparf,qpzd,idstar)
c
c...this does least squares to coordinate + proper motion + parallax
c
c   nummp is used to override the level of fit
c   modezd is used to control zd fit/use
c
      include 'pa6inc1.inc'
      parameter (l1=lc+1,l2=lc+2,l3=lc+3,l4=lc+4)
      dimension qparf(*),qpzd(*)
      dimension zlhs(lc),zrhs(lc,lc),dv(lc),coef(lc),scoef(lc),
     * qcoord(lp),qresid(lp),qfit(lp),sqfit(lp),kok(lp)
      equivalence (zrhs(1,1),work3(1,1)),(zlhs(1),work3(1,l1)),
     * (dv(1),work3(1,l2)),(coef(1),work3(1,l3)),(scoef(1),work3(1,l4))
      equivalence (qcoord(1),work1(1,1)),(qresid(1),work1(1,2)),
     * (qfit(1),work1(1,3)),(sqfit(1),work1(1,4)),(kok(1),work1(1,5))
      data nmax/5/, nalt/3/, pfeps/0.100/, zdeps/0.050/
c
 9601 FORMAT (' SINGULAR MATRIX IN MPFIT...NFIT=', I3,
     * '   idstar=', i3)
 9602 FORMAT (1X, I3, 4(2X, F10.4))
c
c...copy
c
      savzd = qfit(4)
      savzds=sqfit(4)
      do 80 i=1,nmax
       qfit(i)=tag
   80 sqfit(i)=tag
      do 90 iplate=1,nplate
   90 qresid(iplate)=tag
      prezd=0.0
      if ((savzd.ne.tag).and.(modezd.eq.1)) prezd=savzd
c
c...compute the included epoch difference
c
c...iflag1=1 means ok to fit and user wants to fit
c
      j=0
      do 120 iplate=1,nplate
      if (tplate(iplate).eq.tag) go to 120
      if (j.ne.0) go to 110
      j=1
      zmin=tplate(iplate)
      zmax=tplate(iplate)
      go to 120
  110 if (tplate(iplate).lt.zmin) zmin=tplate(iplate)
      if (tplate(iplate).gt.zmax) zmax=tplate(iplate)
  120 continue
      iflag1=0
      if (j.eq.0) go to 130
      if ((zmax-zmin).lt.epeps) go to 130
      if (ifitok(mfit,nummp,1).eq.0) go to 130
      iflag1=1
  130 continue
c
c...compute the included parallax factor difference
c
c...iflag2=1 means ok to fit and user wants to fit
c
      j=0
      do 150 iplate=1,nplate
      if (qparf(iplate).eq.tag) go to 150
      if (j.ne.0) go to 140
      j=1
      zmin=qparf(iplate)
      zmax=qparf(iplate)
      go to 150
  140 if (qparf(iplate).lt.zmin) zmin=qparf(iplate)
      if (qparf(iplate).gt.zmax) zmax=qparf(iplate)
  150 continue
      iflag2=0
      if (j.eq.0) go to 160
      if ((zmax-zmin).lt.pfeps) go to 160
      if (ifitok(mfit,nummp,2).eq.0) go to 160
      iflag2=1
  160 continue
c
c...compute the included zenith distance difference
c
c...iflag3=1 means ok to fit and user wants to fit
c
      j=0
      do 180 iplate=1,nplate
      if (qpzd(iplate).eq.tag) go to 180
      if (j.ne.0) go to 170
      j=1
      zmin=qpzd(iplate)
      zmax=qpzd(iplate)
      go to 180
  170 if (qpzd(iplate).lt.zmin) zmin=qpzd(iplate)
      if (qpzd(iplate).gt.zmax) zmax=qpzd(iplate)
  180 continue
      iflag3=0
      if (j.eq.0) go to 190
      if ((zmax-zmin).lt.zdlimt) go to 190
      if (ifitok(mfit,nummp,4).eq.0) go to 190
      if (prezd.ne.0.0) go to 190
      iflag3=1
  190 continue
c
c...count the number of valid data poitns
c
c...kok(i)=1 for acceptable points
c
      nraw=0
      nvalid=0
      do 210 iplate=1,nplate
      kok(iplate)=0
      if (qcoord(iplate).eq.tag) go to 210
      nraw=nraw+1
      if ((iflag1.eq.1).and.(tplate(iplate).eq.tag)) go to 210
      if ((iflag2.eq.1).and.( qparf(iplate).eq.tag)) go to 210
      if ((iflag3.eq.1).and.(  qpzd(iplate).eq.tag)) go to 210
      nvalid=nvalid+1
      kok(iplate)=1
  210 continue
c
c...if there are too few points, exit
c
      if (nraw.ge.1) go to 230
       qfit(4)=savzd
      sqfit(4)=savzds
      in=0
      return
c
c...the mean coordinates is computed
c
  230 w=0.0
      y=0.0
      z=0.0
      do 240 iplate=1,nplate
      if (kok(iplate).eq.0) go to 240
      w=w + wplate(iplate)
      y=y + wplate(iplate)*tplate(iplate)
      z=z + wplate(iplate)*qcoord(iplate)
  240 continue
c      tbar=0.0
c      if (w.gt.0.0) tbar=y/w
      cbar=0.0
      if (w.gt.0.0) cbar=z/w
c
c...fit to mean only if requested fit cannot be done
c
      nfit=1 + iflag1 + iflag2 + iflag3
      free=nvalid - (nfit+1)
c===>
      free=nvalid - nfit
c
      if ((nfit.gt.1).and.(free.gt.0.0)) go to 400
      w=0.0
      c=0.0
      z=0.0
      do 260 iplate=1,nplate
      if (qcoord(iplate).eq.tag) go to 260
      w=w + wplate(iplate)
      c=c + wplate(iplate)*(qcoord(iplate) - prezd*qpzd(iplate))
      z=z + wplate(iplate)*prezd*qpzd(iplate)
  260 continue
      cbar=0.0
      if (w.gt.0.0) cbar=c/w
      zbar=0.0
      if (w.gt.0.0) zbar=z/w
      w=0.0
      z=0.0
      do 270 iplate=1,nplate
      if (qcoord(iplate).eq.tag) go to 270
      y=qcoord(iplate) - (cbar + prezd*qpzd(iplate))
      qresid(iplate)=y
      w=w + wplate(iplate)
      z=z + wplate(iplate)*y*y
  270 continue
      if (w.gt.0.0) z=sqrt(z/w)
       qfit(1)=cbar + zbar
      sqfit(1)=z
       qfit(4)=savzd
      sqfit(4)=savzds
      return
c
c...here to fit to the requested parameters
c
  400 do 410 ifit=1,nfit
      zlhs(ifit)=0.0
      do 410 jfit=1,nfit
  410 zrhs(ifit,jfit)=0.0
      do 430 iplate=1,nplate
      if (kok(iplate).eq.0) go to 430
      ifit=1
      dv(ifit)=1.0
      if (iflag1.eq.0) go to 412
      ifit=ifit + 1
      dv(ifit)=tplate(iplate) - tbar
  412 if (iflag2.eq.0) go to 414
      ifit=ifit + 1
      dv(ifit)=qparf(iplate)
  414 if (iflag3.eq.0) go to 416
      ifit=ifit + 1
      dv(ifit)=qpzd(iplate)
  416 w=wplate(iplate)
c==>
c      if ((idstar.eq.1).and.(lookp(iplate).ge.500)) w=0.0
c
      z=qcoord(iplate) - (cbar + prezd*qpzd(iplate))
      do 420 ifit=1,nfit
      zlhs(ifit)=zlhs(ifit) + w*z*dv(ifit)
      do 420 jfit=1,nfit
  420 zrhs(ifit,jfit)=zrhs(ifit,jfit) + w*dv(ifit)*dv(jfit)
  430 continue
      call matinv(zrhs,nfit,lc,det)
      if (det.ne.0.0) go to 435
      write (*,9601,iostat=junk) nfit, idstar
      do 432 i=1,nplate
  432 write (*,9602,iostat=junk) i,qcoord(i),tplate(i),qparf(i),qpzd(i)
      call doclose(0)
      stop 'fortran stop...singular matrix in mpfit'
  435 do 440 ifit=1,nfit
      coef(ifit)=0.0
      do 440 jfit=1,nfit
  440 coef(ifit)=coef(ifit) + zrhs(ifit,jfit)*zlhs(jfit)
      chisq=0.0
      do 470 iplate=1,nplate
      if (kok(iplate).eq.0) go to 470
      ifit=1
      dv(ifit)=1.0
      if (iflag1.eq.0) go to 452
      ifit=ifit + 1
      dv(ifit)=tplate(iplate) - tbar
  452 if (iflag2.eq.0) go to 454
      ifit=ifit + 1
      dv(ifit)=qparf(iplate)
  454 if (iflag3.eq.0) go to 456
      ifit=ifit + 1
      dv(ifit)=qpzd(iplate)
  456 w=wplate(iplate)
c==>
c      if ((idstar.eq.1).and.(lookp(iplate).ge.500)) w=0.0
c
      zc=cbar + prezd*qpzd(iplate)
      do 460 ifit=1,nfit
  460 zc=zc + coef(ifit)*dv(ifit)
      z=qcoord(iplate) - zc
      qresid(iplate)=z
      chisq=chisq + w*z*z
  470 continue
      stder=sqrt(chisq/free)
      do 480 ifit=1,nfit
  480 scoef(ifit)=stder*sqrt(zrhs(ifit,ifit))
      ifit=1
       qfit(1)= coef(ifit)
      sqfit(1)=scoef(ifit)
      if (iflag1.eq.0) go to 482
      ifit=ifit + 1
      call damper(coef(ifit),scoef(ifit),qfit(2),sqfit(2),fdamp,tag)
  482 if (iflag2.eq.0) go to 484
      ifit=ifit + 1
      call damper(coef(ifit),scoef(ifit),qfit(3),sqfit(3),fdamp,tag)
  484 if (iflag3.eq.0) go to 486
      ifit=ifit + 1
      call damper(coef(ifit),scoef(ifit),qfit(4),sqfit(4),fdamp,tag)
  486 qfit(1)=qfit(1) + cbar
      if ((savzd.eq.tag).or.(modezd.eq.0)) go to 490
       qfit(4)=savzd
      sqfit(4)=savzds
  490 continue
c
      return
      end
