      SUBROUTINE  nutation(iyy,idn,ihh,imm,iss, alpha,delta, nx,ny)
c
c...Compute Nutation
c
      IMPLICIT
     *            NONE
      REAL
     *            alpha, delta, nx, ny
      INTEGER
     *            iyy, idn, ihh, imm, iss, iload
      REAL*8
     *            zalpha, zdelta, sa, ca, sd, cd, p2, e2,
     *            rcor, dcor, t1, l1, slon, clon, sobl,
     *            cobl, dyear, sl1, cl1, degrad, timrad, dist
      DATA
     *            iload/0/
c
c...OneTime Initialization
c
      IF (iload.eq.0) THEN
        iload = 1
        degrad = ATAN(1.0D00)/45.0D00
        timrad = 15.0D00*degrad
      ENDIF
c
c...Copy And Compute Various SIN/COS
c
      zalpha = alpha
      zdelta = delta
      sa = SIN(zalpha*timrad)
      ca = COS(zalpha*timrad)
      sd = SIN(zdelta*degrad)
      cd = COS(zdelta*degrad)
      CALL decimal_year(iyy,idn,ihh,imm,iss, dyear)
      CALL getsun(iyy,idn,ihh,imm,iss, slon,clon, sobl,cobl, dist)
c
c...Start To Compute
c
      t1 = 0.5D00 + (dyear - 50.0D00)/100.0D00
      l1 = 259.18D00 - 1934.14D00*t1
      CALL makeangle(l1)
      sl1 = SIN(l1*degrad)
      cl1 = COS(l1*degrad)
      p2 = 3.6147D00 - 17.23D00*sl1
      e2 = 9.21D00*cl1 - 9.005D00
      rcor = p2*(cobl*cd + sobl*sa*sd) - e2*ca*sd
      dcor = p2*sobl*ca + e2*sa
      nx = rcor/(54000.0D00*cd)
      ny = dcor/3600.0D00
      RETURN
      END
