      SUBROUTINE  pmmfit
c
c...Fit The Plate Constants For Use In Correcting PMM
c
c	Z Coordinate Passed In TPLATE
c
      INCLUDE
     *            'pa6inc1.inc'
      DIMENSION
     *            xx(LP), yx(LP), yy(LP), yr(LP), yt(LP), rr(LP),
     *            ss(3), cc(3)
      EQUIVALENCE
     *            (xx(1),work1(1,1)), (yx(1),work1(1,2)),
     *            (yy(1),work1(1,3)), (yr(1),work1(1,4)),
     *            (yt(1),work1(1,5)), (rr(1),work1(1,6))
c
 9001 FORMAT (i2, 7(1x,1pe14.7))
 9002 FORMAT (5(1x,1pe14.7), i5, 2(0pf10.4))
c
c...Sanity Check
c
  100 DO iplate=1,nplate
        DO i=1,3
          IF (inxfit(i,iplate).eq.0) GO TO 110
          IF (inyfit(i,iplate).eq.0) GO TO 110
        ENDDO
      ENDDO
c
c...Fill The Fitting Arrays
c
      IF ((ipick.ge.1).and.(ipick.le.nplate)) THEN
        t0 = tplate(ipick)
      ELSE
        t0 = tplate(1)
      ENDIF
      DO iplate=1,nplate
        rc = 0.5*(pconx(2,iplate)+pcony(3,iplate))
        rs = 0.5*(pconx(3,iplate)-pcony(2,iplate))
        r = SQRT(rc*rc + rs*rs)
        t = ATAN2D(rs,rc)
        xx(iplate) = tplate(iplate) - t0
        yx(iplate) = pconx(1,iplate)
        yy(iplate) = pcony(1,iplate)
        yr(iplate) = r
        yt(iplate) = t
      ENDDO
      WRITE (3,9002) t0
c
c...Do The Fits
c
      nc = 2
      CALL polyfit(nplate,xx,yx,rr,nc,cc,ss,stder)
      WRITE (3,9001) nc,(cc(i),i=1,nc),(ss(i),i=1,nc),stder
      nc = 2
      CALL polyfit(nplate,xx,yy,rr,nc,cc,ss,stder)
      WRITE (3,9001) nc,(cc(i),i=1,nc),(ss(i),i=1,nc),stder
      nc = 3
      CALL polyfit(nplate,xx,yr,rr,nc,cc,ss,stder)
      WRITE (3,9001) nc,(cc(i),i=1,nc),(ss(i),i=1,nc),stder
      nc = 2
      CALL polyfit(nplate,xx,yt,rr,nc,cc,ss,stder)
      WRITE (3,9001) nc,(cc(i),i=1,nc),(ss(i),i=1,nc),stder
c
c...Write All Data
c
      DO i=1,nplate
        WRITE (3,9002) xx(i),yx(i),yy(i),yr(i),yt(i),lookp(i),
     *                 pmcon(i),pmsig(i)
      ENDDO
      RETURN
c
c...Here If Only Constants Fit
c
  110 c = 1.0D00
      s = 0.0D00
      DO i=1,nplate
        WRITE (3,9002) tplate(i),pconx(1,i),pcony(1,i),c,s,lookp(i),
     *                 pmcon(i),pmsig(i)
      ENDDO
      RETURN
      END
