      subroutine resids
c
c...dump of current residuals
c
c	modified: 15-oct-86  stderr for unit weight plate
c	modified: 10-dec-86  temp:plate.lis file added
c	modified: 26-may-89  somebody else opens and closes unit=4
c	modified: 05-aug-89  star number and in/out on same line as sigmas
c
      include 'pa6inc1.inc'
      parameter  nhbin=7
      dimension  qhbinx(nhbin), zhbinx(nhbin), prcnt(nhbin),
     *           qhbiny(nhbin), zhbiny(nhbin), total(nhbin)
c
 9401 FORMAT ('1RESIDUALS FOR: ', 10A1 /)
 9402 FORMAT (1H0, 5X, I8, 1H], 8X, 3HRAW, 18X, 4HCALC, 13X,
     * 8hresidual, 4x)
 9403 FORMAT (1X, 2I5, 3X, F10.1, 1H,, F10.1, 1X, F10.1, 1H,, F10.1,
     * 1x, f10.1, 1h,, f10.1)
 9404 FORMAT (' *=', I8, '   I=', I1, '   N=', I3, '   X:(',
     *        f6.3, ',', f6.3, ')   y:(', f6.3, ',', f6.3, ')')
 9405 FORMAT (/// ' SOLUTION (MEAN/SIGMA)   X:(', F6.3, ',', F6.3,
     * ')    y:(', f6.3, ',', f6.3, ')', '   n=', i4)
 9411 FORMAT ('    BINS:', 10(1X, F5.2))
 9412 FORMAT ('   COUNT:', 10(1X, F5.0))
 9413 FORMAT (' PERCENT:', 10(1X, F5.1))
 9414 FORMAT ('   TOTAL:', 10(1X, F5.1))
 9415 FORMAT ('0HISTOGRAM OF X-RESIDUALS   N=', F5.0)
 9416 FORMAT ('0HISTOGRAM OF Y-RESIDUALS   N=', F5.0)
c
c...compute and list the current residuals, etc.
c
  100 qx1=0.0
      qx2=0.0
      qy1=0.0
      qy2=0.0
      qw =0.0
      nq =0
      write (4,9401) (ititle(l),l=1,lt)
      do 460 istar=1,nstar
c
c...=====> here is a patch for only the included stars
c
c      if (instar(istar).eq.0) go to 460
c
      write (4,9402) looks(istar)
      sw =0.0
      sx =0.0
      sy =0.0
      sxx=0.0
      syy=0.0
      iq=0
      do 210 iplate=1,nplate
      w=wplate(iplate)
      x=xresid(istar,iplate)
      y=yresid(istar,iplate)
      if ((x.eq.tag).or.(y.eq.tag).or.(w.eq.tag)) go to 210
      sw =sw  + 1.0
      sx =sx  + w*x
      sy =sy  + w*y
      sxx=sxx + w*x*x
      syy=syy + w*y*y
      if (instar(istar).eq.0) go to 210
      qw =qw  + 1.0
      qx1=qx1 + w*x
      qx2=qx2 + w*x*x
      qy1=qy1 + w*y
      qy2=qy2 + w*y*y
      iq = iq + 1
  210 write (4,9403,iostat=junk) lookp(iplate),instar(istar),
     *  xcoord(istar,iplate),ycoord(istar,iplate),
     *   xcalc(istar,iplate), ycalc(istar,iplate),
     *  xresid(istar,iplate),yresid(istar,iplate)
      if (iq.eq.nplate) nq=nq+1
      if (sw.eq.0.0) go to 220
      sx =sx/sw
      sy =sy/sw
      sxx=sqrt(sxx/sw - sx*sx)
      syy=sqrt(syy/sw - sy*sy)
      l = sw + 0.5
      write (4,9404,iostat=junk) looks(istar),instar(istar),l,
     *                           sx,sxx,sy,syy
  220 continue
c
c...with sigma-x and sigma-y known, assemble a histogram
c
  300 do 310 i=1,nhbin
      qhbinx(i)=0.0
      qhbiny(i)=0.0
      zhbinx(i)=i*sxx/2.0
  310 zhbiny(i)=i*syy/2.0
c
      do 350 iplate=1,nplate
      w=wplate(iplate)
      x=xresid(istar,iplate)
      y=yresid(istar,iplate)
      if  ((x.eq.tag).or.(y.eq.tag)
     * .or.(w.eq.tag).or.(w.eq.0.0)) go to 350
      x=abs(x)
      y=abs(y)
      do 320 i=1,nhbin-1
      if (x.gt.zhbinx(i)) go to 320
      qhbinx(i)=qhbinx(i) + 1.0
      go to 330
  320 continue
      qhbinx(nhbin)=qhbinx(nhbin) + 1.0
  330 do 340 i=1,nhbin-1
      if (y.gt.zhbiny(i)) go to 340
      qhbiny(i)=qhbiny(i) + 1.0
      go to 350
  340 continue
      qhbiny(nhbin)=qhbiny(nhbin) + 1.0
  350 continue
c
  400 x=0.0
      do 410 i=1,nhbin
  410 x=x + qhbinx(i)
      if (x.le.0.0) go to 430
      z=100.0/x
      prcnt(1)=qhbinx(1)*z
      total(1)=prcnt(1)
      do 420 i=2,nhbin
      prcnt(i)=qhbinx(i)*z
  420 total(i)=total(i-1) + prcnt(i)
      write (4,9415,iostat=junk) x
      write (4,9411,iostat=junk) (zhbinx(i),i=1,nhbin-1)
      write (4,9412,iostat=junk) (qhbinx(i),i=1,nhbin)
      write (4,9413,iostat=junk) (prcnt(i),i=1,nhbin)
      write (4,9414,iostat=junk) (total(i),i=1,nhbin)
  430 x=0.0
      do 440 i=1,nhbin
  440 x=x + qhbiny(i)
      if (x.le.0.0) go to 460
      z=100.0/x
      prcnt(1)=qhbiny(1)*z
      total(1)=prcnt(1)
      do 450 i=2,nhbin
      prcnt(i)=qhbiny(i)*z
  450 total(i)=total(i-1) + prcnt(i)
      write (4,9416) x
      write (4,9411,iostat=junk) (zhbiny(i),i=1,nhbin-1)
      write (4,9412,iostat=junk) (qhbiny(i),i=1,nhbin)
      write (4,9413,iostat=junk) (prcnt(i),i=1,nhbin)
      write (4,9414,iostat=junk) (total(i),i=1,nhbin)
  460 continue
c
c...close and exit
c
  500 if (qw.le.0.0) go to 510
      qx1=qx1/qw
      qy1=qy1/qw
      qx2=sqrt(qx2/qw - qx1*qx1)
      qy2=sqrt(qy2/qw - qy1*qy1)
      write (4,9405,iostat=junk) qx1,qx2,qy1,qy2,nq
  510 call plresid
      CLOSE (4)
      return
      end
