      subroutine zeromp
c
c...this enforces the condition that the reference frame have both
c    proper motion and parallax zero in the mean
c
      include 'pa6inc1.inc'
c
 9201 FORMAT ('0<X-MU>=', F6.3, '+/-', F5.3,
     *     5x, '<y-mu>=', f6.3, '+/-', f5.3,
     *     5x, '<x-pi>=', f6.3, '+/-', f5.3,
     *     5x, '<y-pi>=', f6.3, '+/-', f5.3)
c
      smx=0.0
      smy=0.0
      spx=0.0
      spy=0.0
      ssmx=0.0
      ssmy=0.0
      sspx=0.0
      sspy=0.0
      wmx=0.0
      wmy=0.0
      wpx=0.0
      wpy=0.0
      do 140 i=1,nstar
      if (instar(i).eq.0) go to 140
      z=xmu(i)
      if ((z.eq.tag).or.(z.eq.0.0)) go to 110
      w=1.0/(xmusig(i)**2)
      smx=smx + w*z
      ssmx=ssmx + w*z*z
      wmx=wmx + w
  110 z=ymu(i)
      if ((z.eq.tag).or.(z.eq.0.0)) go to 120
      w=1.0/(ymusig(i)**2)
      smy=smy + w*z
      ssmy=ssmy + w+z*z
      wmy=wmy + w
  120 z=xpar(i)
      if ((z.eq.tag).or.(z.eq.0.0)) go to 130
      w=1.0/(xpasig(i)**2)
      spx=spx + w*z
      sspx=sspx + w*z*z
      wpx=wpx + w
  130 z=ypar(i)
      if ((z.eq.tag).or.(z.eq.0.0)) go to 140
      w=1.0/(ypasig(i)**2)
      spy=spy + w*z
      sspy=sspy + w*z*z
      wpy=wpy + w
  140 continue
      xmbar=0.0
      xmsig=0.0
      if (wmx.le.0.0) go to 150
      xmbar=smx/wmx
      xmsig=sqrt(abs(ssmx/wmx - xmbar*xmbar))
  150 ymbar=0.0
      ymsig=0.0
      if (wmy.le.0.0) go to 160
      ymbar=smy/wmy
      ymsig=sqrt(abs(ssmy/wmy - ymbar*ymbar))
  160 xpbar=0.0
      xpsig=0.0
      if (wpx.le.0.0) go to 170
      xpbar=spx/wpx
      xpsig=sqrt(abs(sspx/wpx - xpbar*xpbar))
  170 ypbar=0.0
      ypsig=0.0
      if (wpy.le.0.0) go to 180
      ypbar=spy/wpy
      ypsig=sqrt(abs(sspy/wpy - ypbar*ypbar))
  180 write (2,9201,iostat=junk) xmbar,xmsig,ymbar,ymsig,xpbar,xpsig,
     * ypbar,ypsig
c
c...now each plate is updated to remove the mean motion and parallax
      do 310 i=1,nstar
      if ((xmu(i).eq.tag).or.(xmu(i).eq.0.0)) go to 220
      xmu(i)=xmu(i) - xmbar
      do 210 j=1,nplate
      if (xcalc(i,j).eq.tag) go to 210
      xcalc(i,j)=xcalc(i,j) - xmbar*(tplate(j)-tbar)
  210 continue
  220 if ((xpar(i).eq.tag).or.(xpar(i).eq.0.0)) go to 240
      xpar(i)=xpar(i) - xpbar
      do 230 j=1,nplate
      if (xcalc(i,j).eq.tag) go to 230
      xcalc(i,j)=xcalc(i,j) - xpbar*parfx(j)
  230 continue
  240 if ((ymu(i).eq.tag).or.(ymu(i).eq.0.0)) go to 260
      ymu(i)=ymu(i) - ymbar
      do 250 j=1,nplate
      if (ycalc(i,j).eq.tag) go to 250
      ycalc(i,j)=ycalc(i,j) - ymbar*(tplate(j)-tbar)
  250 continue
  260 if ((ypar(i).eq.tag).or.(ypar(i).eq.0.0)) go to 280
      ypar(i)=ypar(i) - ypbar
      do 270 j=1,nplate
      if (ycalc(i,j).eq.tag) go to 270
      ycalc(i,j)=ycalc(i,j) - ypbar*parfy(j)
  270 continue
  280 st=0.0
      spx=0.0
      spy=0.0
      do 290 j=1,nplate
      w=wplate(j)
      if ((j.eq.tag).or.(j.eq.0.0)) go to 290
      st=st + w*(tplate(j)-tbar)
      spx=spx + w*parfx(j)
      spy=spy + w*parfy(j)
      sw=sw + w
  290 continue
      if (sw.lt.0.0) go to 310
      if (xbar(i).eq.tag) go to 300
      xbar(i)=xbar(i) - xmbar*st/sw - xpbar*spx/sw
  300 if (ybar(i).eq.tag) go to 310
      ybar(i)=ybar(i) - ymbar*st/sw - ypbar*spy/sw
  310 continue
      return
      end
