      SUBROUTINE  lookup1(ident,err,mra,mdec)
c
c...Look This Plate Up In POSSI.CAT
c
      INCLUDE
     *            'slalib.inc'
      CHARACTER*(*)
     *            ident
      CHARACTER*132
     *            lb, qb
      CHARACTER*7
     *            cplate, cdate, cdec
      CHARACTER*6
     *            cra, cfilt
      CHARACTER*5
     *            ctype, cha
      CHARACTER*4
     *            ctime
      CHARACTER*3
     *            mon, monlist(12)
      CHARACTER*2
     *            emul
      INTEGER
     *            nlb, nident, err, id, exp, mm, dd, yy, gotit, nqb,
     *            rah, ram, decd, decm, uthh, utmm,
     *            cyy, cdn, j
      DOUBLE PRECISION
     *            ra2000, dec2000, ra, dec, ut, ep, ras, decs, dist,
     *            mra, mdec
      DATA
     *            monlist/'JAN', 'FEB', 'MAR', 'APR', 'MAY', 'JUN',
     *                    'JUL', 'AUG', 'SEP', 'OCT', 'NOV', 'DEC'/
c
 9001 FORMAT (i6)
 9002 FORMAT (q, a)
 9003 FORMAT (i6, 3(1x,a), 2x,a, 1x,a, 1x,2f10.0, 2(1x,a), 2x,i3,
     *        1x,a)
 9004 FORMAT (i2, a, i2)
 9005 FORMAT (2i2, f2.0)
 9006 FORMAT (2i2)
c
c...Crack IDENT
c
  100 nident = LEN(ident)
      emul = ident(1:2)
      obs_emul = 256*ICHAR(ident(1:1)) + ICHAR(ident(2:2))
      READ (ident(3:nident),9001,err=200) field_id
c
c...Look In Catalog
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=210,
     *      form='formatted',
     *      name='/uz6/xpmm/sg5/possi.cat',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9002,end=220)
      gotit = 0
  110 READ (1,9002,err=110,end=220) nqb,qb
      READ (qb(1:6),9001,err=110) id
      IF (id.ne.field_id) THEN
        IF (gotit.eq.0) THEN
          GO TO 110
        ELSE
          GO TO 120
        ENDIF
      ENDIF
      READ (qb(1:nqb),9003,err=230) id,cplate,cdate,ctime,cra,cdec,
     *                              ra2000,dec2000,ctype,cfilt,exp,cha
      IF (emul(2:2).ne.ctype(5:5)) GO TO 110
      lb = qb
      nlb = nqb
      gotit = 1
      GO TO 110
  120 CLOSE (1)
      READ (lb(1:nlb),9003) id,cplate,cdate,ctime,cra,cdec,
     *                      ra2000,dec2000,ctype,cfilt,exp,cha
      READ (cdate,9004,err=240) dd,mon,yy
      yy = yy+1900
c
c...Parse Catalog Entry
c
      DO mm=1,12
        IF (monlist(mm).eq.mon) GO TO 130
      ENDDO
      GO TO 240
  130 READ (cra,9005,err=240) rah,ram,ras
      CALL sla_DTF2R(rah,ram,ras, ra,j)
      IF (j.ne.0) GO TO 250
      READ (cdec(2:7),9005,err=240) decd,decm,decs
      dec = decd + decm/60.0D00 + decs/3600.0D00
      CALL sla_DAF2R(decd,decm,decs, dec,j)
      IF (j.ne.0) GO TO 250
      IF (INDEX(cdec,'-').gt.0) THEN
        dec = -dec
      ENDIF
      READ (ctime,9006,err=240) uthh,utmm
      ut = uthh + utmm/60.0D00 + exp/120.0D00
c
c...Precess To J2000 And Copy Into Common
c
      CALL sla_CALYD(yy,mm,dd, cyy,cdn,j)
      IF (j.ne.0) GO TO 250
      IF (MOD(yy,4).eq.0) THEN
        ep = cyy + (cdn + ut/24.0D00 - 1)/366.0D00
      ELSE
        ep = cyy + (cdn + ut/24.0D00 - 1)/365.0D00
      ENDIF
      field_epoch = 2000.0D00
      field_mra = ra
      field_mdec = dec
      mra = field_mra
      mdec = field_mdec
      CALL sla_PRECES('FK5',ep,field_epoch,field_mra,field_mdec)
      field_ut = ut
      field_yy = yy
      field_mm = mm
      field_dd = dd
c
c...Compute Corners Of Plate For Extraction
c
      radian = 45.0D00/ATAN(1.0D00)
      obs_hwide = 7.0D00*25.4D00
      obs_scale = 67.18D00
      dist = obs_hwide*obs_scale/(radian*3600.0D00)
      CALL sla_DTP2S(-dist,-dist, field_mra,field_mdec,
     *               ra_corner(1),dec_corner(1))
      CALL sla_DTP2S( dist,-dist, field_mra,field_mdec,
     *               ra_corner(2),dec_corner(2))
      CALL sla_DTP2S(-dist, dist, field_mra,field_mdec,
     *               ra_corner(3),dec_corner(3))
      CALL sla_DTP2S( dist, dist, field_mra,field_mdec,
     *               ra_corner(4),dec_corner(4))
      err = 0
      RETURN
c
c...Errors
c
  200 err = -2
      RETURN
  210 err = -3
      RETURN
  220 IF (gotit.ne.0) GO TO 120
      CLOSE (1)
      err = -4
      RETURN
  230 CLOSE (1)
      err = -5
      RETURN
  240 err = -6
      RETURN
  250 err = -7
      RETURN
      END
