      SUBROUTINE  scanacrs(ramin,ramax,decmin,decmax,flipx)
c
c...Scan Sorted ACRS Catalog In Memory
c
      INCLUDE
     *            'possacrs.inc'
      PARAMETER
     *            nchunk = 50,
     *            perchunk = ((NMAX-1)/NCHUNK)+1,
     *            xmin = (xmid-wide),
     *            xmax = (xmid+wide),
     *            ymin = (ymid-wide),
     *            ymax = (ymid+wide),
     *            only1 = 1
      INTEGER
     *            irmin, irmax, idmin, idmax, i, j, frst, last,
     *            ixi, ieta, flipx
      DOUBLE PRECISION
     *            ramin, ramax, decmin, decmax, ra, dec, rra, rdec,
     *            pmx, pmy, rpmra, rpmdec, radian, pmra
c
c...Compute INTEGER Version Of RA/DEC
c
  100 irmin = ramin*RFACTOR
      irmax = ramax*RFACTOR + 0.999D00
      idmin = (decmin+90.0D00)*DFACTOR
      idmax = (decmax+90.0D00)*DFACTOR
      radian = 45.0D00/ATAN(1.0D00)
c
c...Find Starting Chunk
c
      DO i=1,NCHUNK-1
        last = i*PERCHUNK
        IF (ra10mas(last).ge.irmin) GO TO 110
      ENDDO
      i = NCHUNK
  110 CONTINUE
c
c...Find Stopping Chunk
c
      DO j=i,NCHUNK-1
        frst = (j-1)*PERCHUNK+1
        IF (ra10mas(frst).gt.irmax) GO TO 120
      ENDDO
      j = NCHUNK
  120 CONTINUE
c
c...Search In Chunks
c
      frst = (i-1)*PERCHUNK+1
      last = MIN(NMAX,j*PERCHUNK)
      DO i=frst,last
        IF (ra10mas(i).ge.irmin) THEN
          IF (ra10mas(i).gt.irmax) GO TO 130
          IF ((spd10mas(i).ge.idmin).and.(spd10mas(i).le.idmax)) THEN
c
c...This Star Is OK.  Convert To IXI,IETA
c
            ra  = ra10mas(i)/RFACTOR
            dec = spd10mas(i)/DFACTOR - 90.0D00
            pmx = 0.001D00*mux1mas(i)
            pmy = 0.001D00*muy1mas(i)
            rra = 15.0D00*ra/radian
            rdec = dec/radian
            pmra = pmx/(15.0D00*COSD(dec))
            rpmra = pmra/( 240.0D00*radian)
            rpmdec = pmy/(3600.0D00*radian)
            CALL toobs(rra,rdec,rpmra,rpmdec,ixi,ieta,flipx)
            IF ((ixi.ge.XMIN).and.(ixi.le.XMAX)
     *      .and.(ieta.ge.YMIN).and.(ieta.le.YMAX)) THEN
              IF ((only1.eq.0).or.(acrsid(i).lt.500000)) THEN
                nfind = nfind+1
                ixfind(nfind) = i
                xi(nfind) = ixi
                eta(nfind) = ieta
                IF (nfind.ge.NFMAX) GO TO 130
              ENDIF
            ENDIF
          ENDIF
        ENDIF
      ENDDO
  130 CONTINUE
      RETURN
      END
