      PROGRAM  rescan
c
c...See If Rescanning Makes Sense
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         nmax = 1000
      DOUBLE PRECISION
     *         osx(NMAX), osy(NMAX), odiff(NMAX), nsx(NMAX), nsy(NMAX),
     *         ndiff(NMAX), x, y, dx, dy
      INTEGER
     *         id, ofind(NMAX), nfind(NMAX), i
c
 9001 FORMAT (i4, 8x, 2f6.2)
 9002 FORMAT (i4, 8f6.2)
c
c...Initialize
c
  100 DO i=1,NMAX
        ofind(i) = 0
        nfind(i) = 0
      ENDDO
c
c...Read Original Measuress
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='taffbr.orig',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
  110 READ (1,9001,end=120) id,x,y
      osx(id) = x
      osy(id) = y
      IF (x.lt.y) THEN
        odiff(id) = -SQRT(y*y-x*x)
      ELSEIF (x.eq.y) THEN
        odiff(id) = 0.0D00
      ELSE
        odiff(id) = SQRT(x*x-y*y)
      ENDIF
      ofind(id) = 1
      GO TO 110
  120 CLOSE (1)
c
c...Read New Measures
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='taffbr.raw',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
  130 READ (1,9001,end=140) id,x,y
      nsx(id) = x
      nsy(id) = y
      IF (x.lt.y) THEN
        ndiff(id) = -SQRT(y*y-x*x)
      ELSEIF (x.eq.y) THEN
        ndiff(id) = 0.0D00
      ELSE
        ndiff(id) = SQRT(x*x-y*y)
      ENDIF
      nfind(id) = 1
      GO TO 130
  140 CLOSE (1)
c
c...Scribble a File to Plot
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='rescan.out',
     *      status='unknown',
     *      unit=1
     *     )
      DO i=1,NMAX
        IF ((ofind(i).ne.0).and.(nfind(i).ne.0)) THEN
          dx = osx(i)-nsx(i)
          dy = osy(i)-nsy(i)
          WRITE (1,9002) i,osx(i),osy(i),odiff(i),nsx(i),nsy(i),ndiff(i)
     *                   ,dx,dy
        ENDIF
      ENDDO
      CLOSE (1)
      CALL EXIT
      END
