      PROGRAM  stats
c
c...Make Sure Things Are Under Control
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         ncols = 1394,
     *         nrows = 1037,
     *         nfoot = 588,
     *         nper = (NCOLS*NROWS*NFOOT)
      PARAMETER
     *         nmax = 1000
      INTEGER
     *         sjfind(NMAX), sffind(NMAX), sjproc(NMAX), sfproc(NMAX),
     *         i, j, nlb, ujfind(NMAX), nsj, nsf, nsjsf, sjird(NMAX),
     *         sfird(NMAX), sjphd(NMAX), nsjd, nsfd, nsjsfd, nujsjd,
     *         npair, n, insane, jj, n1, n2, m1, m2, nsjsnd, nsn,
     *         snfind(NMAX), snproc(NMAX), nsnd, snird(NMAX), nsjsn
      CHARACTER*64
     *         lb
      CHARACTER*2
     *         survey
      DOUBLE PRECISION
     *         dra, ddec, sigmax, sigmay, f, ha, zd, ut, z, dlon, dlat,
     *         nsjp, nsfp, nsnp
c
 9001 FORMAT (q, a)
 9002 FORMAT (i4)
 9003 FORMAT (' SJ', i4.4, ' Is Not Unique')
 9004 FORMAT (' SF', i4.4, ' Is Not Unique')
 9005 FORMAT (' SJ', i4.4, ' Has Not Been Processed')
 9006 FORMAT (' SF', i4.4, ' Has Not Been Processed')
 9007 FORMAT (' N(SJ)=', i4, '  N(SF)=', i4, '  N(SJ+SF)=', i4,
     *        '  N(SN)=', i4, '  N(SJ+SN)=', i4)
 9008 FORMAT (' SJ', i4.4, ' Missing IRD File')
 9009 FORMAT (' SJ', i4.4, ' Missing PHD File')
 9010 FORMAT (' SJ', i4.4, '.IRD Is Extra')
 9011 FORMAT (' SJ', i4.4, '.PHD Is Extra')
 9012 FORMAT (' SF', i4.4, ' Missing IRD File')
 9013 FORMAT (' SF', i4.4, '.IRD Is Extra')
 9014 FORMAT (i4, i8, 2f6.2, i8, f6.1, 4f8.3, 2f7.3, i5, i8, 2f8.3,
     *        4i8)
 9015 FORMAT (' SJ Detections=', i10, '  Pixels=', f15.0)
 9016 FORMAT (' SF Detections=', i10, '  Pixels=', f15.0)
 9017 FORMAT (' SJ+SF Detections=', i10)
 9018 FORMAT (' UJ+SJ Detections=', i10)
 9019 FORMAT (' SN Detections=', i10, '  Pixels=', f15.0)
 9020 FORMAT (' SJ+SN Detections=', i10)
 9021 FORMAT (' SN', i4.4, ' Is Not Unique')
 9022 FORMAT (' SN', i4.4, ' Has Not Been Processed')
 9023 FORMAT (' SN', i4.4, ' Missing IRD File')
 9024 FORMAT (' SN', i4.4, '.IRD Is Extra')
c
c...Initialization
c
  100 DO i=1,NMAX
        sjfind(i) = 0
        sffind(i) = 0
        snfind(i) = 0
        sjproc(i) = 0
        sfproc(i) = 0
        snfind(i) = 0
        ujfind(i) = 0
        sjird(i) = 0
        sfird(i) = 0
        sjphd(i) = 0
      ENDDO
      nsjd = 0
      nsfd = 0
      nujsjd = 0
      nsjsfd = 0
      nsjsnd = 0
      nsjp = 0.0D00
      nsfp = 0.0D00
      nsnd = 0
      nsnp = 0.0D00
c
c...Scan UE0/UE1 For Recent Additions
c
      CALL system('\ls /ue0/xpmm/lists  >scan.lis')
      CALL system('\ls /ue1/xpmm/lists >>scan.lis')
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='delete',
     *      form='formatted',
     *      name='scan.lis',
     *      status='old',
     *      unit=1
     *     )
  110 READ (1,9001,end=120) nlb,lb
      IF (nlb.le.10) GO TO 110
      IF (lb(nlb-2:nlb).ne.'dat') GO TO 110
      READ (lb(nlb-8:nlb-5),9002,err=110) j
      IF ((j.lt.1).or.(j.gt.NMAX)) GO TO 110
      survey = lb(nlb-10:nlb-9)
      IF (survey.eq.'sj') THEN
        sjfind(j) = 1
      ELSEIF (survey.eq.'sf') THEN
        sffind(j) = 1
      ELSEIF (survey.eq.'sn') THEN
        snfind(i) = 1
      ELSEIF (survey.eq.'uj') THEN
        ujfind(j) = 1
      ENDIF
      GO TO 110
  120 CLOSE (1)
c
c...Look For UJ/SJ Solutions
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='taffbr.raw',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
  130 READ (1,9014,end=140) j,npair,sigmax,sigmay,n,f,dra,ddec,
     * ha,zd,ut,z,insane,jj,dlon,dlat,n1,n2,m1,m2
      IF ((j.lt.1).or.(j.gt.NMAX)) GO TO 130
      sjproc(j) = sjproc(j)+1
      nsjd = nsjd + n2
      nsjp = nsjp + NPER
      nujsjd = nujsjd + npair
      GO TO 130
  140 CLOSE (1)
c
c...Look For SJ/SF Solutions
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='../autojf/taffjf.raw',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
  150 READ (1,9014,end=160) j,npair,sigmax,sigmay,n,f,dra,ddec,
     * ha,zd,ut,z,insane,jj,dlon,dlat,n1,n2,m1,m2
      IF ((j.lt.1).or.(j.gt.NMAX)) GO TO 150
      sfproc(j) = sfproc(j)+1
      nsfd = nsfd + n2
      nsfp = nsfp + NPER
      nsjsfd = nsjsfd + npair
      GO TO 150
  160 CLOSE (1)
c
c...Look For SJ/SN Solutions
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='../autojn/taffjn.raw',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
  310 READ (1,9014,end=320) j,npair,sigmax,sigmay,n,f,dra,ddec,
     * ha,zd,ut,z,insane,jj,dlon,dlat,n1,n2,m1,m2
      IF ((j.lt.1).or.(j.gt.NMAX)) GO TO 310
      snproc(j) = snproc(j)+1
      nsnd = nsnd + n2
      nsnp = nsnp + NPER
      nsjsnd = nsjsnd + npair
      GO TO 310
  320 CLOSE (1)
c
c...Look For IRD Files
c
      CALL system('\ls $AUXIRD >scan.lis')
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='delete',
     *      form='formatted',
     *      name='scan.lis',
     *      status='old',
     *      unit=1
     *     )
  170 READ (1,9001,end=180) nlb,lb
      IF (nlb.le.9) GO TO 170
      READ (lb(nlb-7:nlb-4),9002,err=170) j
      IF ((j.lt.1).or.(j.gt.NMAX)) GO TO 170
      survey = lb(nlb-9:nlb-8)
      IF (survey.eq.'sj') THEN
        sjird(j) = 1
      ELSEIF (survey.eq.'sf') THEN
        sfird(j) = 1
      ELSEIF (survey.eq.'sn') THEN
        snird(j) = 1
      ENDIF
      GO TO 170
  180 CLOSE (1)
c
c...Look For PHD Files
c
      CALL system('\ls $SJPHD >scan.lis')
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='delete',
     *      form='formatted',
     *      name='scan.lis',
     *      status='old',
     *      unit=1
     *     )
  190 READ (1,9001,end=200) nlb,lb
      IF (nlb.le.9) GO TO 190
      READ (lb(nlb-7:nlb-4),9002) j
      IF ((j.lt.1).or.(j.gt.NMAX)) GO TO 190
      survey = lb(nlb-9:nlb-8)
      IF (survey.eq.'sj') THEN
        sjphd(j) = 1
      ENDIF
      GO TO 190
  200 CLOSE (1)
c
c...Sense Double Processing Of SJ and SF
c
      DO i=1,NMAX
        IF (sjproc(i).gt.1) THEN
          WRITE (*,9003) i
        ENDIF
        IF (sfproc(i).gt.1) THEN
          WRITE (*,9004) i
        ENDIF
        IF (snproc(i).gt.1) THEN
          WRITE (*,9021) i
        ENDIF
      ENDDO
c
c...Sense Missing SJ and SF
c
      DO i=1,NMAX
        IF ((sjfind(i).gt.0).and.(sjproc(i).le.0)) THEN
          WRITE (*,9005) i
        ENDIF
        IF ((sffind(i).gt.0).and.(sfproc(i).le.0)) THEN
          WRITE (*,9006) i
        ENDIF
        IF ((snfind(i).gt.0).and.(snproc(i).le.0)) THEN
          WRITE (*,9022) i
        ENDIF
      ENDDO
c
c...Sense Proper Processing
c
      DO i=1,NMAX
        IF (sjproc(i).ne.0) THEN
          IF (sjird(i).le.0) THEN
            WRITE (*,9008) i
          ELSE
            sjird(i) = 0
          ENDIF
          IF (sjphd(i).le.0) THEN
            WRITE (*,9009) i
          ELSE
            sjphd(i) = 0
          ENDIF
        ENDIF
      ENDDO
      DO i=1,NMAX
        IF (sjird(i).ne.0) THEN
          WRITE (*,9010) i
        ENDIF
        IF (sjphd(i).ne.0) THEN
          WRITE (*,9011) i
        ENDIF
      ENDDO
      DO i=1,NMAX
        IF (sfproc(i).ne.0) THEN
          IF (sfird(i).le.0) THEN
            WRITE (*,9012) i
          ELSE
            sfird(i) = 0
          ENDIF
        ENDIF
        IF (snproc(i).ne.0) THEN
          IF (snird(i).le.0) THEN
            WRITE (*,9023) i
          ELSE
            snird(i) = 0
          ENDIF
        ENDIF
      ENDDO
      DO i=1,NMAX
        IF (sfird(i).ne.0) THEN
          WRITE (*,9013) i
        ENDIF
        IF (snird(i).ne.0) THEN
          WRITE (*,9024) i
        ENDIF
      ENDDO
c
c...Dumb Statistics
c
      nsj = 0
      nsf = 0
      nsn = 0
      nsjsf = 0
      nsjsn = 0
      DO i=1,NMAX
        IF (sjproc(i).gt.0) THEN
          nsj = nsj+1
          IF (sfproc(i).gt.0) THEN
            nsjsf = nsjsf+1
          ENDIF
          IF (snproc(i).gt.0) THEN
            nsjsn = nsjsn+1
          ENDIF
        ELSE
          IF (sfproc(i).gt.0) THEN
            nsf = nsf+1
          ENDIF
          IF (snproc(i).gt.0) THEN
            nsn = nsn+1
          ENDIF
        ENDIF
      ENDDO
      WRITE (*,9007) nsj,nsf,nsjsf,nsn,nsjsn
      WRITE (*,9015) nsjd,nsjp
      WRITE (*,9016) nsfd,nsfp
      WRITE (*,9019) nsnd,nsnp
      WRITE (*,9018) nujsjd
      WRITE (*,9017) nsjsfd
      WRITE (*,9020) nsjsnd
c
c...Make Sure UJ File Is In Order
c
      CALL system('sort -n taffbr.raw >x')
      CALL system('cp x taffbr.raw')
      CALL EXIT
      END
