      SUBROUTINE  iterb(fatal,nc,manual)
c
c...Full Array Iteration
c
      INCLUDE
     *         'cuproc.inc'
      INTEGER
     *         ok, err, nold, fatal, nc, manual, last
c
 9001 FORMAT (' Fatal Error In Pairfit')
 9002 FORMAT (' NPAIR=', i6, '  Sx=', f10.2, '   Sx=', f10.2,
     *        '  NCoef=', i2)
 9003 FORMAT (' Enter Find Radius (Micron): ' $)
 9004 FORMAT (f10.0)
c
  100 rmicron = 20.0
      nold = npair
  110 CALL xformpar
      CALL pairfind
      CALL pairfit(x1, xcoef,sxcoef,sigmax, err)
      IF (err.ne.0) THEN
        WRITE (*,9001)
        fatal = 9
        RETURN
      ENDIF
      CALL pairfit(y1, ycoef,sycoef,sigmay, err)
      IF (err.ne.0) THEN
        WRITE (*,9001)
        fatal = 10
        RETURN
      ENDIF
      sigmax = 0.01D00*sigmax
      sigmay = 0.01D00*sigmay
      WRITE (*,9002) npair,sigmax,sigmay,ncoef
c
c...Iterate Until NPAIR Is The Same
c
      IF (manual.eq.0) THEN
        IF (npair.ne.nold) THEN
          nold = npair
          GO TO 110
        ENDIF
      ELSE
        CALL isitok(ok)
        IF (ok.ge.0) THEN
          IF (ok.eq.0) THEN
  120       WRITE (*,9003)
            READ  (*,9004,err=120,end=200) rmicron
          ENDIF
          GO TO 110
        ENDIF
      ENDIF
c
c...Final (Hopefully Quick) Iteration For More Plate Constants)
c
      IF (nc.gt.ncoef) THEN
        ncoef = nc
        last = 0
  130   CALL pairfind
        CALL pairfit(x1, xcoef,sxcoef,sigmax, err)
        IF (err.ne.0) THEN
          WRITE (*,9001)
          fatal = 7
          RETURN
        ENDIF
        CALL pairfit(y1, ycoef,sycoef,sigmay, err)
        IF (err.ne.0) THEN
          WRITE (*,9001)
          fatal = 8
          RETURN
        ENDIF
        sigmax = 0.01D00*sigmax
        sigmay = 0.01D00*sigmay
        WRITE (*,9002) npair,sigmax,sigmay,ncoef
        IF ((last.eq.0).or.(npair.ne.nold)) THEN
          last = 1
          nold = npair
          CALL xformpar
          GO TO 130
        ENDIF
      ENDIF
      RETURN
c
c...Read EOF
c
  200 CALL EXIT
      END
