      SUBROUTINE  prelim(nlist,list)
c
c...Make Listing Of Files
c
      INCLUDE
     *            'cuproc.inc'
      PARAMETER
     *            ndir = 20
      INTEGER
     *            nlist, list(*), i, j, nlb, IARGC, ntb, n
      CHARACTER*132
     *            lb, tb
      CHARACTER*2
     *            id
      CHARACTER*3
     *            dir(NDIR)
      DATA
     *    dir/'uu0', 'uu1', 'uw0', 'uw1', 'ua0', 'ua1', 'ub0', 'ub1',
     *        'uc0', 'uc1', 'ud0', 'ud1', 'ue0', 'ue1', 'uf0', 'uf1',
     *        'ug0', 'ug1', 'uh0', 'uh1'/
c
 9001 FORMAT (q, a)
 9002 FORMAT (i4)
 9003 FORMAT (' Cannot Open SCANNED.LIS')
 9004 FORMAT (' No Files In SCANNED.LIS')
 9005 FORMAT (' Cannot Open DONE.LIS')
 9006 FORMAT (' No Stars Remain To Be Done')
 9007 FORMAT (' Cannot Open DONE.LIS')
 9008 FORMAT (i5, 2f10.0)
 9009 FORMAT (' Cannot Open TAFF Tables')
 9010 FORMAT (' Taff Tables Are Incorrect Size')
 9013 FORMAT (1x, 2f10.0)
c
c...Generate A List Of Files That Have Been Scanned
c
  100 CALL system('cp /dev/null scanned.lis')
      DO i=1,NDIR
        CALL system('\ls /'//dir(i)//'/xpmm/lists >>scanned.lis')
      ENDDO
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=200,
     *      form='formatted',
     *      name='scanned.lis',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      nlist = 0
  110 READ (1,9001,err=110,end=120) nlb,lb
      IF (nlb.le.0) GO TO 110
      i = INDEX(lb(1:nlb),'.dat')
      IF (i.le.6) GO TO 110
      IF (lb(i-7:i-6).ne.'uj') GO TO 110
      READ (lb(i-5:i-2),9002,err=110) j
      IF ((j.le.0).or.(j.ge.8000)) GO TO 110
      nlist = nlist+1
      list(nlist) = j
      GO TO 110
  120 CLOSE (1)
      IF (nlist.le.0) GO TO 210
c
c...Remove Those Files That Have Been Done
c
      IF (redo.eq.0) THEN
        IF (catalog.eq.0) THEN
          IF (dotaff.eq.0) THEN
            CALL system('\ls $AUXCU >done.lis')
          ELSE
            CALL system('\ls $AUXDU >done.lis')
          ENDIF
        ELSE
          IF (dotaff.eq.0) THEN
            CALL system('\ls $AUXPU >done.lis')
          ELSE
            CALL system('\ls $AUXQU >done.lis')
          ENDIF
        ENDIF
        OPEN (
     *        access='sequential',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        err=220,
     *        form='formatted',
     *        name='done.lis',
     *        readonly,
     *        shared,
     *        status='old',
     *        unit=1
     *       )
  130   READ (1,9001,err=130,end=140) nlb,lb
        IF (nlb.le.0) GO TO 130
        i = INDEX(lb(1:nlb),'.fit')
        IF (i.le.5) GO TO 130
        READ (lb(i-4:i-1),9002,err=130) j
        DO i=1,nlist
          IF (list(i).eq.j) THEN
            list(i) = 0
            GO TO 130
          ENDIF
        ENDDO
        GO TO 130
  140   CLOSE (1)
      ENDIF
      j = 0
      DO i=1,nlist
        IF (list(i).ne.0) THEN
          j = j+1
          list(j) = list(i)
        ENDIF
      ENDDO
      nlist = j
      IF (j.le.0) GO TO 230
c
c...Open The LOG File
c
      IF (catalog.eq.0) THEN
        IF (dotaff.eq.0) THEN
          tb = 'acrs.lis'
          ntb = 8
        ELSE
          tb = 'taffacrs.lis'
          ntb = 12
        ENDIF
      ELSE
        IF (dotaff.eq.0) THEN
          tb = 'ppm.lis'
          ntb = 7
        ELSE
          tb = 'taffppm.lis'
          ntb = 11
        ENDIF
      ENDIF
      OPEN (
     *      access='append',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=240,
     *      form='formatted',
     *      name=tb(1:ntb),
     *      status='unknown',
     *      unit=2
     *     )
      tb(ntb-2:ntb) = 'raw'
      OPEN (
     *      access='append',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=240,
     *      form='formatted',
     *      name=tb(1:ntb),
     *      status='unknown',
     *      unit=3
     *     )
c
c...Load The Taff-o-Gram Tables
c
      z0taff = 0.0D00
      dztaff = 0.0D00
      DO i=1,8
        holex0(i) = 0.0D00
        holey0(i) = 0.0D00
      ENDDO
      DO j=1,NTDIM
        DO i=1,NTDIM
          xtaff(i,j) = 0.0D00
          ytaff(i,j) = 0.0D00
        ENDDO
      ENDDO
      IF (dotaff.ne.0) THEN
        CALL f_doenv('LISTS:taff.hdr',nlb,lb)
        OPEN (
     *        access='sequential',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        err=250,
     *        form='formatted',
     *        name=lb(1:nlb),
     *        readonly,
     *        shared,
     *        status='old',
     *        unit=1
     *       )
        READ (1,9008) n,z0taff,dztaff
        DO i=1,8
          READ (1,9013) holex0(i),holey0(i)
        ENDDO
        CLOSE (1)
        IF (n.ne.NTDIM) GO TO 260
        lb(nlb-2:nlb) = 'dat'
        OPEN (
     *        access='direct',
     *        carriagecontrol='none',
     *        convert='big_endian',
     *        dispose='keep',
     *        err=250,
     *        form='unformatted',
     *        name=lb(1:nlb),
     *        readonly,
     *        recl=(2*NTDIM*NTDIM),
     *        recordtype='fixed',
     *        shared,
     *        status='old',
     *        unit=1
     *       )
        READ (1,rec=1) xtaff
        READ (1,rec=2) ytaff
        CLOSE (1)
      ENDIF
c
c...Load POSSII.CAT To Get Other Database Pieces
c
      CALL possload
      RETURN
c
c...Errors
c
  200 WRITE (*,9003)
      CALL EXIT
  210 WRITE (*,9004)
      CALL EXIT
  220 WRITE (*,9005)
      CALL EXIT
  230 WRITE (*,9006)
      CALL EXIT
  240 WRITE (*,9007)
      CALL EXIT
  250 WRITE (*,9009)
      CALL EXIT
  260 WRITE (*,9010)
      CALL EXIT
      END
