      PROGRAM  ujinven
c
c...Compare RAW vs. LOGBOOK
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         nmax = 1000
      INTEGER
     *         i, inraw(NMAX), inlog(NMAX)
      CHARACTER*2
     *         s
c
 9001 FORMAT (i5)
 9002 FORMAT (i6, 1x, a)
 9003 FORMAT (i5, ' Measured But Not in POSSII.CAT')
 9004 FORMAT (i5, ' In POSSII.CAT But Not Measured')
c
c...Initialization
c
  100 DO i=1,NMAX
        inraw(i) = 0
        inlog(i) = 0
      ENDDO
c
c...Process RAW
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='taffppm.raw',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
  110 READ (1,9001,end=120) i
      IF ((i.gt.0).and.(i.le.NMAX)) THEN
        inraw(i) = inraw(i)+1
      ENDIF
      GO TO 110
  120 CLOSE (1)
c
c...Process LOGBOOK
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='/uz6/xpmm/sg5/tycho/possii.cat',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9002)
  130 READ (1,9002,end=140) i,s
      IF (s.eq.'UJ') THEN
        IF ((i.gt.0).and.(i.le.NMAX)) THEN
          inlog(i) = inlog(i)+1
        ENDIF
      ENDIF
      GO TO 130
  140 CLOSE (1)
c
c...Compare
c
      DO i=1,nmax
        IF ((inraw(i).ne.0).and.(inlog(i).eq.0)) THEN
          WRITE (*,9003) i
        ELSEIF ((inraw(i).eq.0).and.(inlog(i).ne.0)) THEN
          WRITE (*,9004) i
        ENDIF
      ENDDO
      CALL EXIT
      END
