      PROGRAM  hist
c
c...Histogram Of RAW Errors
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         boxmin = 2.0,
     *         boxwide = 0.25,
     *         boxnum = 21,
     *         np = boxnum+1
      CHARACTER*64
     *         lb
      INTEGER
     *         nlb, i, j, k
      REAL
     *         x, y, xbox(BOXNUM), ybox(BOXNUM), px(NP), py(NP),
     *         xmin, xmax, ymin, ymax, zbox(BOXNUM)
c
 9001 FORMAT (' Enter RAW File: ' $)
 9002 FORMAT (q, a)
 9003 FORMAT (i5, i6, 2f6.0)
c
c...Initialization
c
  100 DO i=1,BOXNUM
        xbox(i) = 0
        ybox(i) = 0.0
      ENDDO
c
c...Read File
c
  110 WRITE (*,9001)
      READ  (*,9002,err=110) nlb,lb
      IF (nlb.le.0) GO TO 110
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=110,
     *      form='formatted',
     *      name=lb(1:nlb),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
  120 READ (1,9003,end=130) j,k,x,y
      j = (x-BOXMIN)/BOXWIDE + 1.0
      IF ((j.ge.1).and.(j.le.BOXNUM)) THEN
        xbox(j) = xbox(j) + 1.0
      ENDIF
      k = (y-BOXMIN)/BOXWIDE + 1.0
      IF ((k.ge.1).and.(k.le.BOXNUM)) THEN
        ybox(k) = ybox(k) + 1.0
      ENDIF
      GO TO 120
  130 CLOSE (1)
c
c...Make MONGO Data Arrays
c
      xmin = 2.0
      xmax = 7.0
      ymin = 0.0
      ymax = 250.0
      DO i=1,BOXNUM
        zbox(i) = BOXMIN + (i-0.5)*BOXWIDE
      ENDDO
      CALL mgosetup(-7)
      CALL mgoinit
      CALL mgosetlim(xmin,ymin,xmax,ymax)
      CALL mgobox(1,2)
      CALL mgosetltype(2)
      CALL mgohistogram(zbox,xbox,BOXNUM)
      CALL mgosetltype(1)
      CALL mgohistogram(zbox,ybox,BOXNUM)
      CALL mgoxlabel(35, 'Astrometric Error vs. PPM (micron)')
      CALL mgoylabel(19, 'Number of UJ Plates')
      CALL mgoprntplot(i)
      CALL EXIT
      END
