      SUBROUTINE  magfit(dochop, zcoef,szcoef,sigmaz, err)
c
c...Least Squares Fit To Magnitude Transformation
c
      INCLUDE
     *            'gbproc.inc'
      DOUBLE PRECISION
     *            zcoef(*), szcoef(*), sigmaz, x, y, z, chisq, zc,
     *            zr, m, dv(NCMAX)
      INTEGER
     *            i, j, k, nn, ising, err, dochop
c
 9001 FORMAT (' Singular Matrix In MAGFIT')
c
c...Initialization
c
  100 DO i=1,nmcoef
        zlhs(i) = 0.0D00
        DO j=1,nmcoef
          zrhs(i,j) = 0.0D00
        ENDDO
      ENDDO
      chisq = 0.0
      sigmaz = SANITYTAG
      nn = 0
c
c...Accumulation
c
      DO i=1,npair
        IF ((dochop.eq.0).or.(tmp(i).ne.0)) THEN
          x = d2(pair2(i))
          z = d1(pair1(i))
          CALL magdv(x,z,dv)
          DO j=1,nmcoef
            zlhs(j) = zlhs(j) + dv(j)*z
            DO k=1,nmcoef
              zrhs(j,k) = zrhs(j,k) + dv(j)*dv(k)
            ENDDO
          ENDDO
          nn = nn+1
        ENDIF
      ENDDO
c
c...Inversion
c
      CALL matinv(nmcoef,ising)
      IF (ising.ne.0) THEN
        WRITE (*,9001)
        err = 1
        RETURN
      ENDIF
c
c...Coefficients
c
      DO i=1,nmcoef
        zcoef(i) = 0.0D00
        DO j=1,nmcoef
          zcoef(i) = zcoef(i) + zrhs(i,j)*zlhs(j)
        ENDDO
      ENDDO
c
c...Residuals And ChiSquared
c
      DO i=1,npair
        x = d2(pair2(i))
        z = d1(pair1(i))
        CALL magdv(x,z,dv)
        IF (nmcoef.eq.1) THEN
          zc = x + zcoef(1)
        ELSE
          zc = 0.0D00
          DO j=1,nmcoef
            zc = zc + zcoef(j)*dv(j)
          ENDDO
        ENDIF
        zr = z-zc
        IF ((dochop.eq.0).or.(tmp(i).ne.0)) THEN
          chisq = chisq + zr*zr
        ENDIF
        tmp(i) = ABS(zr)+0.5D00
      ENDDO
      sigmaz = SQRT(chisq/(nn-(nmcoef+1)))
c
c...Correct For Equal Weights
c
      sigmaz = sigmaz/SQRT(2.0D00)
c
c...Errors
c
      DO i=1,nmcoef
        szcoef(i) = sigmaz*SQRT(zrhs(i,i))
      ENDDO
c
c...Convert To User's Units
c
      sigmaz = 0.01D00*sigmaz
      err = 0
      RETURN
      END
