      PROGRAM  uj10stats
c
c...Compute Progress Statistics
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         nfield = 1000
      INTEGER
     *         nplate, nacrs, nraw, i, j, field(NFIELD), nppm
      CHARACTER*27
     *         lb
c
 9001 FORMAT (i5, i6)
 9002 FORMAT (i10)
 9003 FORMAT ('/uw0/xpmm/lists/uj', i4.4, 'a.inf')
 9004 FORMAT (' N(Plate)=', i4, '  N(ACRS)=', i6, '  N(PPM)=', i6,
     *        ' N(Raw)=', i10)
 9005 FORMAT (' ACRS Field ', i4, ' Is Not Unique')
 9006 FORMAT (' PPM Field ', i4, ' Is Not Unique')
 9007 FORMAT (' Field ', i4, ' Is Only In ACRS')
 9008 FORMAT (' Field ', i4, ' Is Only In PPM')
c
c...Initialization
c
  100 DO i=1,NFIELD
        field(i) = 0
      ENDDO
      nacrs = 0
      nppm = 0
      nplate = 0
c
c...Process ACRS
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='uj10log.raw',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
  110 READ (1,9001,end=120) i,j
      IF (IAND(field(i),1).ne.0) THEN
        WRITE (*,9005) i
        GO TO 110
      ENDIF
      nacrs = nacrs+j
      field(i) = field(i)+1
      GO TO 110
  120 CLOSE (1)
c
c...Process PPM
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='uj10ppm.raw',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
  130 READ (1,9001,end=140) i,j
      IF (IAND(field(i),2).ne.0) THEN
        WRITE (*,9006) i
        GO TO 130
      ENDIF
      nppm = nppm+j
      field(i) = field(i)+2
      GO TO 130
  140 CLOSE (1)
c
c...Process Fields
c
      DO i=1,NFIELD
        IF (field(i).ne.0) THEN
          nplate = nplate+1
          IF (field(i).eq.1) THEN
            WRITE (*,9007) i
          ELSEIF (field(i).eq.2) THEN
            WRITE (*,9008) i
          ENDIF
          WRITE (lb,9003) i
          OPEN (
     *          access='sequential',
     *          carriagecontrol='list',
     *          dispose='keep',
     *          err=150,
     *          form='formatted',
     *          name=lb,
     *          readonly,
     *          shared,
     *          status='old',
     *          unit=1
     *         )
          GO TO 160
  150     lb(4:4) = '1'
          OPEN (
     *          access='sequential',
     *          carriagecontrol='list',
     *          dispose='keep',
     *          form='formatted',
     *          name=lb,
     *          readonly,
     *          shared,
     *          status='old',
     *          unit=1
     *         )
  160     READ (1,9002) j
          nraw = nraw+j
          CLOSE (1)
        ENDIF
      ENDDO
c
c...All Done
c
      WRITE (*,9004) nplate,nacrs,nppm,nraw
      CALL EXIT
      END
