      PROGRAM  zlog
c
c...Add Z To Parameter List
c
      IMPLICIT
     *         NONE
      CHARACTER*27
     *         lb
      INTEGER
     *         id, np, nacrs, sg, i, n
      REAL
     *         sx, sy, f, ra, dec, ha, zd, ep, z, l, zc, zr, x, y
      DOUBLE PRECISION
     *        frz0(21,28), frl0(21,28), frx0(21,28), fry0(21,28)
c
 9001 FORMAT ('/uw0/xpmm/lists/uj', i4.4, 'a.hdr')
 9002 FORMAT (' Cannot Open', a)
 9003 FORMAT (2i10)
 9004 FORMAT (4(1x,1pe20.10))
 9007 FORMAT (i5, i6, f6.2, f6.2, i6, f6.1, 4f8.3, 3f7.3, i2, f7.3,
     *        2f7.1)
c
c...Open Old File
c
  100 OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='glop',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='zlog.raw',
     *      status='unknown',
     *      unit=2
     *     )
c
c...Read Each Line, Get ID, And Get HDR
c
  110 READ (1,9007,end=140) id,np,sx,sy,nacrs,f,ra,dec,ha,zd,ep
      WRITE (lb,9001) id
      sg = 0
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      err=120,
     *      form='unformatted',
     *      name=lb,
     *      readonly,
     *      recl=(2*588),
     *      recordtype='fixed',
     *      shared,
     *      status='old',
     *      unit=3
     *     )
      GO TO 130
  120 lb(4:4) = '1'
      sg = 1
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      err=200,
     *      form='unformatted',
     *      name=lb,
     *      readonly,
     *      recl=(2*588),
     *      recordtype='fixed',
     *      shared,
     *      status='old',
     *      unit=3
     *     )
  130 READ (3,rec=1) frx0
      READ (3,rec=2) fry0
      READ (3,rec=3) frz0
      READ (3,rec=6) frl0
      CLOSE (3)
      do i=1,21
      x = frz0(i,14)-frl0(i,14)
      write (*,9991) i,frx0(i,14),fry0(i,14),frz0(i,14),
     * frl0(i,14),x
      enddo
      pause
 9991 format (i5,5f10.3)
c
c...Look In HDR For ZETAREF
c
      lb(25:27) = 'inf'
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name=lb,
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=3
     *     )
      READ (3,9003)
      READ (3,9004)
      READ (3,9003) n
      DO i=1,n
        READ (3,9004)
      ENDDO
      READ (3,9003) n
      DO i=1,n
        READ (3,9004)
        READ (3,9004)
      ENDDO
      READ (3,9004) zc,zr
      CLOSE (3)
      IF (zr.eq.0.0) GO TO 110
c
c...Compute Mean Z At Central Footprint And Save
c
      z = 0.5D00*(frz0(11,14)+frz0(11,15))
      l = 0.5D00*(frl0(11,14)+frl0(11,15))
      x = 0.5D00*(frx0(11,14)+frx0(11,15))
      y = 0.5D00*(fry0(11,14)+fry0(11,15))
      WRITE (2,9007) id,np,sx,sy,nacrs,f,ra,dec,ha,zd,ep,z,l,sg,zr,
     *               x,y
      GO TO 110
c
c...All Done
c
  140 CLOSE (1)
      CLOSE (2)
      CALL EXIT
c
c...Errors
c
  200 WRITE (*,9002) lb
      GO TO 110
      END
