      SUBROUTINE  magbox(dochop, zcoef,szcoef,sigmaz, err)
c
c...Fit To Mean Of Magnitude Boxes
c
      INCLUDE
     *            'grproc.inc'
      DOUBLE PRECISION
     *            zcoef(*), szcoef(*), sigmaz, x, y, z, chisq, a, b,
     *            m, dv(NCMAX), mbox(25), sbox(25), zc(25), zr(25)
      INTEGER
     *            i, j, k, nn, ising, err, dochop, nbox(25), nin, nlb
      CHARACTER*64
     *            lb
c
 9001 FORMAT (' Singular Matrix In MAGBOX')
 9002 FORMAT (' NPair=', i10, ' Fitting N=', i10)
 9003 FORMAT (i2, i10, 4f10.2)
 9004 FORMAT (3i3, f10.2, 2i10)
 9005 FORMAT (i2, 2(1x, 1pe15.8))
c
c...Take Mean In Magnitude Bins
c
  100 DO i=minmag,maxmag
        mbox(i) = 0.0D00
        sbox(i) = 0.0D00
        nbox(i) = 0
      ENDDO
      nin = 0
      DO i=1,npair
        IF ((dochop.eq.0).or.(tmp(i).ne.0)) THEN
          k = d2(pair2(i))/100
          IF ((k.ge.minmag).and.(k.le.maxmag)) THEN
            z = d1(pair1(i))
            mbox(k) = mbox(k) + z
            sbox(k) = sbox(k) + z*z
            nbox(k) = nbox(k) + 1
            nin = nin+1
          ENDIF
        ENDIF
      ENDDO
      WRITE (*,9002) npair,nin
      DO i=minmag,maxmag
        IF (nbox(i).gt.0) THEN
          mbox(i) = mbox(i)/nbox(i)
          sbox(i) = SQRT(sbox(i)/nbox(i) - mbox(i)*mbox(i))
        ENDIF
      ENDDO
c
c...Initialization
c
      DO i=1,nmcoef
        zlhs(i) = 0.0D00
        DO j=1,nmcoef
          zrhs(i,j) = 0.0D00
        ENDDO
      ENDDO
      chisq = 0.0
      sigmaz = SANITYTAG
      nn = 0
c
c...Accumulation
c
      DO i=minmag,maxmag
        IF (nbox(i).gt.0) THEN
          x = 100*i + 50
          z = mbox(i)
          CALL magdv(x,z,dv)
          DO j=1,nmcoef
            zlhs(j) = zlhs(j) + dv(j)*z
            DO k=1,nmcoef
              zrhs(j,k) = zrhs(j,k) + dv(j)*dv(k)
            ENDDO
          ENDDO
          nn = nn+1
        ENDIF
      ENDDO
c
c...Inversion
c
      CALL matinv(nmcoef,ising)
      IF (ising.ne.0) THEN
        WRITE (*,9001)
        err = 1
        RETURN
      ENDIF
c
c...Coefficients
c
      DO i=1,nmcoef
        zcoef(i) = 0.0D00
        DO j=1,nmcoef
          zcoef(i) = zcoef(i) + zrhs(i,j)*zlhs(j)
        ENDDO
      ENDDO
c
c...Residuals And ChiSquared
c
      DO i=minmag,maxmag
        IF (nbox(i).gt.0) THEN
          x = 100*i + 50
          z = mbox(i)
          CALL magdv(x,z,dv)
          IF (nmcoef.eq.1) THEN
            zc(i) = x + zcoef(1)
          ELSE
            zc(i) = 0.0D00
            DO j=1,nmcoef
              zc(i) = zc(i) + zcoef(j)*dv(j)
            ENDDO
          ENDIF
          zr(i) = z-zc(i)
          chisq = chisq + zr(i)*zr(i)
          tmp(i) = ABS(zr(i))+0.5D00
        ELSE
          tmp(i) = -1
        ENDIF
      ENDDO
      sigmaz = SQRT(chisq/(nn-(nmcoef+1)))
c
c...Errors And User Units
c
      DO i=1,nmcoef
        szcoef(i) = sigmaz*SQRT(zrhs(i,i))
      ENDDO
      sigmaz = 0.01D00*sigmaz
c
c...Save
c
      CALL f_doenv(fnout(1:nfnout)//'.phx',nlb,lb)
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=200,
     *      form='formatted',
     *      name=lb(1:nlb),
     *      status='unknown',
     *      unit=1
     *     )
      WRITE (1,9004) minmag,maxmag,nmcoef,sigmaz,npair,nin
      DO i=minmag,maxmag
        x = mbox(i)*0.01D00
        y = sbox(i)*0.01D00
        a = zc(i)*0.01D00
        b = zr(i)*0.01D00
        WRITE (1,9003) i,nbox(i),x,y,a,b
      ENDDO
      DO i=1,nmcoef
        WRITE (1,9005) i,zcoef(i),szcoef(i)
      ENDDO
      CLOSE (1)
c
c...All Done
c
  200 err = 0
      RETURN
      END
