      SUBROUTINE  smallfit(zz, zcoef,szcoef,sigmaz,err)
c
c...Least Squares Fit To Plate Constants From BIG Arrays
c
      INCLUDE
     *            'grproc.inc'
      DOUBLE PRECISION
     *            zcoef(*), szcoef(*), sigmaz, x, y, z, chisq, zc,
     *            zr, m, dv(NCMAX)
      INTEGER
     *            i, j, k, nn, zz(*), ising, err
c
 9001 FORMAT (' Singular Matrix In SMALLFIT')
c
c...Initialization
c
  100 DO i=1,ncoef
        zlhs(i) = 0.0D00
        DO j=1,ncoef
          zrhs(i,j) = 0.0D00
        ENDDO
      ENDDO
      chisq = 0.0
      sigmaz = TAG
c
c...Accumulation
c
      DO i=1,npair
        x = x2p(pair2(i))/SCALE
        y = y2p(pair2(i))/SCALE
        m = 0.01D00*m2p(pair2(i))
        z = zz(pair1(i))/SCALE
        CALL filldv(x,y,m,dv)
        DO j=1,ncoef
          zlhs(j) = zlhs(j) + dv(j)*z
          DO k=1,ncoef
            zrhs(j,k) = zrhs(j,k) + dv(j)*dv(k)
          ENDDO
        ENDDO
      ENDDO
c
c...Inversion
c
      CALL matinv(ncoef,ising)
      IF (ising.ne.0) THEN
        WRITE (*,9001)
        err = 1
        RETURN
      ENDIF
c
c...Coefficients
c
      DO i=1,ncoef
        zcoef(i) = 0.0D00
        DO j=1,ncoef
          zcoef(i) = zcoef(i) + zrhs(i,j)*zlhs(j)
        ENDDO
      ENDDO
c
c...Residuals And ChiSquared
c
      DO i=1,npair
        x = x2p(pair2(i))/SCALE
        y = y2p(pair2(i))/SCALE
        m = 0.01D00*m2p(pair2(i))
        z = zz(pair1(i))/SCALE
        CALL filldv(x,y,m,dv)
        zc = 0.0D00
        DO j=1,ncoef
          zc = zc + zcoef(j)*dv(j)
        ENDDO
        zr = z-zc
        chisq = chisq + zr*zr
      ENDDO
      sigmaz = SQRT(chisq/(npair-(ncoef+1)))
c
c...Errors
c
      DO i=1,ncoef
        szcoef(i) = sigmaz*SQRT(zrhs(i,i))
      ENDDO
c
c...Convert To User's Units
c
      sigmaz = SCALE*sigmaz
      err = 0
      RETURN
      END
