      SUBROUTINE  pairfind
c
c...Look In Sorted Lists For Pairs
c
      INCLUDE
     *            'jfproc.inc'
      PARAMETER
     *            npmax = 100
      INTEGER
     *            get, low, high, r, xl, xh, nfind,
     *            ifind(NPMAX), jfind(NPMAX), test, yl,
     *            yh, yt, j
      DOUBLE PRECISION
     *            dx, dy, dr, rfind(NPMAX), z, rsqr
c
c...Initialization
c
  100 get = 0
      npair = 0
      low = 1
      high = 1
      r = rmicron*100.0D00 + 0.5D00
      rsqr = (r/SCALE)**2
c
c...Outer Loop Over (1) Index
c
  110 get = get+1
      IF (get.gt.n1) THEN
        RETURN
      ENDIF
      IF (index1(get).le.0) GO TO 110
      xl = x1(get) - r
      xh = x1(get) + r
      yl = y1(get) - r
      yh = y1(get) + r
c
c...Inner Loop Brackets (2)
c
  120 CONTINUE
      IF (x2hat(low).lt.xl) THEN
        IF (low.lt.n2) THEN
          low = low+1
          GO TO 120
        ENDIF
      ENDIF
      IF (x2hat(low).gt.xh) GO TO 110
      IF (high.lt.low) THEN
        high = low
      ENDIF
  130 CONTINUE
      IF (high.lt.n2) THEN
        IF (x2hat(high+1).le.xh) THEN
          high = high+1
          GO TO 130
        ENDIF
      ENDIF
c
c...Test All Unique Entries In This Range
c
      nfind = 0
      DO test=low,high
        j = idx(test)
        IF (index2(j).gt.0) THEN
          yt = y2hat(test)
          IF ((yt.ge.yl).and.(yt.le.yh)) THEN
            dy = ((yt-y1(get))/SCALE)**2
            IF (dy.le.rsqr) THEN
              dx = ((x2hat(test)-x1(get))/SCALE)**2
              dr = dx+dy
              IF (dr.le.rsqr) THEN
                IF (nfind.lt.NPMAX) THEN
                  nfind = nfind+1
                  ifind(nfind) = get
                  jfind(nfind) = j
                  rfind(nfind) = d2(j)
                ENDIF
              ENDIF
            ENDIF
          ENDIF
        ENDIF
      ENDDO
c
c...Save Pairs
c
      IF (nfind.gt.0) THEN
        npair = npair+1
        pair1(npair) = ifind(1)
        pair2(npair) = jfind(1)
        z = rfind(1)
        DO test=2,nfind
          IF (rfind(test).lt.z) THEN
            pair1(npair) = ifind(test)
            pair2(npair) = jfind(test)
            z = rfind(test)
          ENDIF
        ENDDO
      ENDIF
c
c...Loop Until Completion.  RETURN Is On GET
c
      GO TO 110
      END
