      PROGRAM  rawcount
c
c...Count Number Of Raw Detections
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         nmax = 894,
     *         nlist = 21,
     *         ncolor = 3
      INTEGER
     *         i, j, count(NMAX,NCOLOR), ilist, nlb, n, m
      CHARACTER*64
     *         lb
      CHARACTER*3
     *         list(NLIST)
      CHARACTER*2
     *         color(NCOLOR)
      CHARACTER*1
     *         c
      DATA
     *  list/'uu0', 'uu1', 'uw0', 'uw1', 'ua0', 'ua1', 'ub0', 'ub1',
     *       'uc0', 'uc1', 'ud0', 'ud1', 'ue0', 'ue1', 'uf0', 'uf1',
     *       'ug0', 'ug1', 'uh0', 'uh1', 'uz6'/
      DATA
     *  color/'sj', 'sf', 'sn'/
c
 9001 FORMAT ('/uuu/xpmm/lists/', a, i4.4, 'a.inf')
 9002 FORMAT (i10)
 9003 FORMAT (' Multiple Entry For ', a, i4.4)
 9004 FORMAT (' Survey ', a, '  N=', i3, '  M=', i12)
c
c...Initialization
c
  100 DO j=1,NCOLOR
        DO i=1,NMAX
          count(i,j) = 0
        ENDDO
      ENDDO
c
c...Outer Loop Over COLOR
c
      DO j=1,NCOLOR
c
c...Next Loop Over Field
c
        DO i=1,NMAX
c
c...Inner Loop Is Over Location
c
          WRITE (lb,9001) color(j),i
          nlb = 27
          DO ilist=1,NLIST
            lb(2:4) = list(ilist)
            OPEN (
     *            access='sequential',
     *            carriagecontrol='list',
     *            dispose='keep',
     *            err=110,
     *            form='formatted',
     *            name=lb(1:nlb),
     *            readonly,
     *            shared,
     *            status='old',
     *            unit=1
     *           )
            GO TO 120
  110       CONTINUE
          ENDDO
          GO TO 140
c
c...First File Was Found
c
  120     READ (1,9002) n
          CLOSE (1)
          IF (count(i,j).ne.0) THEN
            WRITE (*,9003) color(j),i
          ENDIF
          count(i,j) = n
          c = 'a'
c
c...Are There More
c
  130     c = CHAR(ICHAR(c)+1)
          lb(nlb-4:nlb-4) = c
          OPEN (
     *          access='sequential',
     *          carriagecontrol='list',
     *          dispose='keep',
     *          err=140,
     *          form='formatted',
     *          name=lb(1:nlb),
     *          readonly,
     *          shared,
     *          status='old',
     *          unit=1
     *         )
          READ (1,9002) n
          CLOSE (1)
          count(i,j) = count(i,j)+n
          GO TO 130
  140     CONTINUE
        ENDDO
      ENDDO
c
c...Tell User
c
      DO j=1,NCOLOR
        n = 0
        m = 0
        DO i=1,NMAX
          IF (count(i,j).gt.0) THEN
            n = n+1
            m = m+count(i,j)
          ENDIF
        ENDDO
        WRITE (*,9004) color(j),n,m
      ENDDO
      CALL EXIT
      END
