      SUBROUTINE  autoext(s,e,wsize,fatal,saveit)
c
c...Look For Pairs In A Small Region
c
      INCLUDE
     *            'jfoeproc.inc'
      PARAMETER
     *            nitmin = 10,
     *            chop = 1.5D00*100.0D00
      INTEGER
     *            i, err, fatal, x1, y1, x2, y2, ww, ne, dx, dy, j,
     *            niter, npold, wsize, saveit
      DOUBLE PRECISION
     *            ox1, oy1, nx1, ny1, tx, ty, s, e
c
 9001 FORMAT (' NIter=', i3, '  NPair=', i10, '  SigmaX=', f6.2,
     *        '  SigmaY=', f6.2)
 9002 FORMAT (' X(', i2, ')=', 1pe14.7, '+/-', 1pe9.3,
     *      '   Y(', i2, ')=', 1pe14.7, '+/-', 1pe9.3)
 9003 FORMAT (' Offset Guess=(', f8.3, ',', f8.3, ')   Find=(', f8.3,
     *        ',', f8.3, ')')
 9004 FORMAT (' NP=' i10, '  N1=', i10, '  N2=', i10)
 9005 FORMAT (' Pair Area Processing Loop')
 9006 FORMAT (' Pair Area Processing Failed')
 9007 FORMAT (' Fatal Error In Dstfit')
 9008 FORMAT (' Chop=', f10.1, '  NOld=', i10, '  NNew=', i10)
 9009 FORMAT (6i12)
c
c...Look In SubAreas
c
  100 WRITE (*,9005)
      x1 = -obs_dxi/2
      x2 =  obs_dxi/2
      y1 = -obs_deta/2
      y2 =  obs_deta/2
      ww = wsize*100000
      stol = s
      etol = e
      DO ne=100,NEXTLIM,50
        CALL extract(1,x1,y1,ww,ne)
        CALL extract(2,x2,y2,ww,ne)
        CALL dsteval
        IF (npover.gt.10) GO TO 110
        IF ((ne.eq.100).and.(saveit.ne.0)) THEN
          OPEN (
     *          access='sequential',
     *          carriagecontrol='list',
     *          dispose='keep',
     *          form='formatted',
     *          name='autoext.lis',
     *          status='unknown',
     *          unit=33
     *         )
          DO i=1,ne
            WRITE (33,9009) xextract(i,1),yextract(i,1),mextract(i,1),
     *                      xextract(i,2),yextract(i,2),mextract(i,2)
          ENDDO
          CLOSE (33)
        ENDIF
      ENDDO
      WRITE (*,9006)
      fatal = 4
      RETURN
  110 niter = 0
      WRITE (*,9001) niter,npover,sigmax(3),sigmay(3)
      DO i=1,ncoef(3)
        WRITE (*,9002) i,xcoef(i,3),sxcoef(i,3),i,ycoef(i,3),sycoef(i,3)
      ENDDO
c
c...Success.  Use This Fit And More Extracted Stars For An Improvement.
c
      dx = -SCALE*xcoef(1,3)
      dy = -SCALE*ycoef(1,3)
      ox1 = 0.00001D00*obs_dxi
      oy1 = 0.00001D00*obs_deta
      nx1 = 0.00001D00*dx
      ny1 = 0.00001D00*dy
      WRITE (*,9003) ox1,oy1,nx1,ny1
      x1 = -dx/2
      x2 =  dx/2
      y1 = -dy/2
      y2 =  dy/2
      CALL qextract(1,x1,y1,ww)
      CALL qextract(2,x2,y2,ww)
c
c...Iterate Until Number Is Constant.
c
      npold = 0
  120 niter = niter+1
      IF ((niter.eq.4).or.(niter.eq.8)) THEN
        j = 0
        tx = 100.0D00*CHOP*sigmax(3)
        ty = 100.0D00*CHOP*sigmay(3)
        DO i=1,npover
          IF ((ABS(xexres(i)).le.tx).and.(ABS(yexres(i)).le.ty)) THEN
            j = j+1
            pover1(j) = pover1(i)
            pover2(j) = pover2(i)
          ENDIF
        ENDDO
      WRITE (*,9008) chop,npover,j
        npover = j
        etol = 0.8D00*etol
      ELSE
        CALL dstxform(3)
        CALL dstfind
      ENDIF
      CALL dstfit(xextract(1,1),xexres(1),xcoef(1,3),sxcoef(1,3),
     *            sigmax(3),err)
      IF (err.ne.0) THEN
        WRITE (*,9007)
        fatal = 5
        RETURN
      ENDIF
      CALL dstfit(yextract(1,1),yexres(1),ycoef(1,3),sycoef(1,3),
     *            sigmay(3),err)
      IF (err.ne.0) THEN
        WRITE (*,9007)
        fatal = 6
        RETURN
      ENDIF
      WRITE (*,9001) niter,npover,sigmax(3),sigmay(3)
c
c...Loop Until Convergance
c
      IF ((niter.lt.NITMIN).or.(npover.ne.npold)) THEN
        npold = npover
        GO TO 120
      ENDIF
      DO i=1,ncoef(3)
        WRITE (*,9002) i,xcoef(i,3),sxcoef(i,3),i,ycoef(i,3),sycoef(i,3)
      ENDDO
c
c...One Last Test
c
      i = 2*npover
      j = MIN(nextract(1),nextract(2))
      IF (i.lt.j) THEN
        fatal = 16
      ENDIF
      RETURN
      END
