      SUBROUTINE  magproc
c
c...Compute Preliminary Mapping Between UJ and SJ
c
      INCLUDE
     *            'jnproc.inc'
      INTEGER
     *            i, dochop, muj, msj, err, test
c
 9001 FORMAT (' Fatal Error In MAGPROC ', i10)
c
c...Quick Return If Nothing To Do
c
  100 IF (newmag.eq.0) RETURN
c
c...First Guess Is To Chop All Unreasonable Values
c
      nmcoef = 2
      dochop = 1
      DO i=1,npair
        muj = d1(pair1(i))
        msj = d2(pair2(i))
        IF ((muj.lt.500).or.(muj.gt.1600)) THEN
          tmp(i) = 0
        ELSEIF ((msj.lt.500).or.(msj.gt.2200)) THEN
          tmp(i) = 0
        ELSE
          tmp(i) = 1
        ENDIF
      ENDDO
      CALL magfit(dochop, mcoef,smcoef,sigmam, err)
      IF (err.ne.0) GO TO 200
c
c...Second Iteration Is A Sanity Test On The Residuals
c
      DO i=1,npair
        IF (tmp(i).le.100) THEN
          tmp(i) = 1
        ELSE
          tmp(i) = 0
        ENDIF
      ENDDO
      CALL magfit(dochop, mcoef,smcoef,sigmam, err)
      IF (err.ne.0) GO TO 200
c
c...Third Iteration Is Based On Sigma
c
      test = 300.0D00*sigmam
      DO i=1,npair
        IF (tmp(i).le.test) THEN
          tmp(i) = 1
        ELSE
          tmp(i) = 0
        ENDIF
      ENDDO
      CALL magfit(dochop, mcoef,smcoef,sigmam, err)
      IF (err.ne.0) GO TO 200
c
c...Final Iteration Is To Fit Median Of Boxes
c
      test = 300.0D00*sigmam
      DO i=1,npair
        IF (tmp(i).le.test) THEN
          tmp(i) = 1
        ELSE
          tmp(i) = 0
        ENDIF
      ENDDO
      CALL magbox(dochop, mcoef,smcoef,sigmam, err)
      IF (err.ne.0) GO TO 200
      RETURN
c
c...Some Sort Of Error
c
  200 newmag = 0
      WRITE (*,9001) err
      RETURN
      END
