      SUBROUTINE  auxplot(s,e,wsize,fatal)
c
c...Plot Small Regions
c
      INCLUDE
     *            'joeproc.inc'
      PARAMETER
     *            npmax = 100,
     *            nitmin = 10,
     *            chop = 1.5D00*100.0D00
      INTEGER
     *            ww, i, err, fatal, x1, y1, x2, y2, wsize, ne,
     *            i1, i2, dx, dy, npold, niter, j
      DOUBLE PRECISION
     *            s, e, ox1, oy1, nx1, ny1, tx, ty
      REAL
     *            xmin, xmax, ymin, ymax, xp, yp
      CHARACTER*1
     *            c
      CHARACTER*4
     *            tb
c
 9001 FORMAT (' Do You Want A Plot (y/n)? ' $)
 9002 FORMAT (a)
 9003 FORMAT (' Input Of Correlated Pairs Loop (Min=6)')
 9004 FORMAT (' Pair(', i2, '): ' $)
 9005 FORMAT (' Pair Plotting Loop W=', i3)
 9006 FORMAT (2i10)
 9007 FORMAT (' X(', i2, ')=', 1pe14.7, '+/-', 1pe9.3,
     *      '   Y(', i2, ')=', 1pe14.7, '+/-', 1pe9.3)
 9008 FORMAT (' Offset Guess=(', f8.3, ',', f8.3, ')  Find=(', f8.3,
     *        ',', f9.3, ')')
 9009 FORMAT (' Chop=', f10.1, '  NOld=', i10, '  NNew=', i10)
 9010 FORMAT (' Fatal Error In DSTFIT')
 9011 FORMAT (' NIter=', i3, '  NPair=', i10, '  Sigmax=', f6.2,
     *        '  SigmaY=', f6.2)
 9020 FORMAT ('X', i1)
 9021 FORMAT ('+', i2)
 9022 FORMAT ('+', i3)
c
c...Look In SubAreas
c
  100 WRITE (*,9005) wsize
      x1 = -obs_dxi/2
      x2 =  obs_dxi/2
      y1 = -obs_deta/2
      y2 =  obs_deta/2
      ww = wsize*100000
      ne = 100
      CALL magextract(1,x1,y1,ww,ne)
      CALL magextract(2,x2,y2,ww,ne)
c
c...Plot If Desired
c
  110 WRITE (*,9001)
      READ  (*,9002,err=110,end=200) c
      IF ((c.ge.'A').and.(c.le.'Z')) THEN
        c = CHAR(ICHAR(c)+32)
      ENDIF
      IF (c.eq.'y') THEN
        CALL mgoinit
        CALL mgosetup(-7)
        xmin = x1-ww
        xmax = x1+ww
        ymin = y1-ww
        ymax = y1+ww
        CALL mgosetlim(xmin,ymin,xmax,ymax)
        CALL mgobox(1,1)
        CALL mgorelocate(xmin,ymin)
        CALL mgoputlabel(7,'(File1)',9)
        DO i=1,nextract(1)
          xp = xextract(i,1)
          yp = yextract(i,1)
          CALL mgorelocate(xp,yp)
          IF (i.le.9) THEN
            WRITE (tb,9020) i
            CALL mgoputlabel(2,tb,6)
          ELSEIF (i.le.99) THEN
            WRITE (tb,9021) i
            CALL mgoputlabel(3,tb,6)
          ELSE
            WRITE (tb,9022) i
            CALL mgoputlabel(4,tb,6)
          ENDIF
        ENDDO
        CALL mgoprntplot(i)
        CALL mgoerase
        xmin = x2-ww
        xmax = x2+ww
        ymin = y2-ww
        ymax = y2+ww
        CALL mgosetlim(xmin,ymin,xmax,ymax)
        CALL mgobox(1,1)
        CALL mgorelocate(xmin,ymin)
        CALL mgoputlabel(7,'(File2)',9)
        DO i=1,nextract(2)
          xp = xextract(i,2)
          yp = yextract(i,2)
          CALL mgorelocate(xp,yp)
          IF (i.le.9) THEN
            WRITE (tb,9020) i
            CALL mgoputlabel(2,tb,6)
          ELSEIF (i.le.99) THEN
            WRITE (tb,9021) i
            CALL mgoputlabel(3,tb,6)
          ELSE
            WRITE (tb,9022) i
            CALL mgoputlabel(4,tb,6)
          ENDIF
        ENDDO
        CALL mgoprntplot(i)
      ELSEIF (c.ne.'n') THEN
        GO TO 110
      ENDIF
c
c...Input For Correlated Pairs
c
      npover = 0
      WRITE (*,9003)
  120 i = npover+1
      WRITE (*,9004) i
      READ  (*,9006) i1,i2
      IF ((i1.le.0).and.(i2.le.0)) THEN
        IF (npover.le.5) THEN
          fatal = -22
          RETURN
        ELSE
          GO TO 130
        ENDIF
      ENDIF
      IF ((i1.le.0).or.(i1.gt.nextract(1))) GO TO 120
      IF ((i2.le.0).or.(i2.gt.nextract(2))) GO TO 120
      npover = npover+1
      pover1(npover) = i1
      pover2(npover) = i2
      GO TO 120
c
c...Attempt A Solution From These Pairs
c
  130 ncoef(3) = 3
      CALL dstfit(xextract(1,1),xexres(1),xcoef(1,3),sxcoef(1,3),
     *            sigmax(3),err)
      IF (err.ne.0) THEN
        WRITE (*,9010)
        fatal = 5
        RETURN
      ENDIF
      CALL dstfit(yextract(1,1),yexres(1),ycoef(1,3),sycoef(1,3),
     *            sigmay(3),err)
      IF (err.ne.0) THEN
        WRITE (*,9010)
        fatal = 6
        RETURN
      ENDIF
      CALL dstxform(3)
      CALL dstfind
c
c...Use This Fit And More Extracted Stars For An Improvement.
c
      dx = -SCALE*xcoef(1,3)
      dy = -SCALE*ycoef(1,3)
      ox1 = 0.00001D00*obs_dxi
      oy1 = 0.00001D00*obs_deta
      nx1 = 0.00001D00*dx
      ny1 = 0.00001D00*dy
      WRITE (*,9008) ox1,oy1,nx1,ny1
      x1 = -dx/2
      x2 =  dx/2
      y1 = -dy/2
      y2 =  dy/2
      CALL qextract(1,x1,y1,ww)
      CALL qextract(2,x2,y2,ww)
c
c...Iterate Until Number Is Constant.
c
      npold = 0
  140 niter = niter+1
      IF ((niter.eq.4).or.(niter.eq.8)) THEN
        j = 0
        tx = 100.0D00*CHOP*sigmax(3)
        ty = 100.0D00*CHOP*sigmay(3)
        DO i=1,npover
          IF ((ABS(xexres(i)).le.tx).and.(ABS(yexres(i)).le.ty)) THEN
            j = j+1
            pover1(j) = pover1(i)
            pover2(j) = pover2(i)
          ENDIF
        ENDDO
        WRITE (*,9009) chop,npover,j
        npover = j
        etol = 0.8D00*etol
      ELSE
        CALL dstxform(3)
        CALL dstfind
      ENDIF
      CALL dstfit(xextract(1,1),xexres(1),xcoef(1,3),sxcoef(1,3),
     *            sigmax(3),err)
      IF (err.ne.0) THEN
        WRITE (*,9010)
        fatal = 5
        RETURN
      ENDIF
      CALL dstfit(yextract(1,1),yexres(1),ycoef(1,3),sycoef(1,3),
     *            sigmay(3),err)
      IF (err.ne.0) THEN
        WRITE (*,9010)
        fatal = 6
        RETURN
      ENDIF
      WRITE (*,9011) niter,npover,sigmax(3),sigmay(3)
c
c...Loop Until Convergance
c
      IF ((niter.lt.NITMIN).or.(npover.ne.npold)) THEN
        npold = npover
        GO TO 140
      ENDIF
      DO i=1,ncoef(3)
        WRITE (*,9007) i,xcoef(i,3),sxcoef(i,3),i,ycoef(i,3),sycoef(i,3)
      ENDDO
c
c...One Last Test
c
      i = 2*npover
      j = MIN(nextract(1),nextract(2))
      IF (i.lt.j) THEN
        fatal = 16
      ENDIF
      RETURN
c
c...Some Fatal Error
c
  200 CALL EXIT
      END
