      SUBROUTINE  dsteval
c
c...Look At Distance Between Pairs
c
      INCLUDE
     *            'joeproc.inc'
      PARAMETER
     *            nesqr = NEXTLIM*NEXTLIM
      INTEGER
     *            dx1(NESQR), dy1(NESQR), dx2(NESQR), dy2(NESQR),
     *            ii1(NESQR), jj1(NESQR), ii2(NESQR), jj2(NESQR),
     *            nl1, nl2, nkeep, test, low, high, xmin, xmax,
     *            ymin, ymax, ki1(NESQR), kj1(NESQR), ki2(NESQR),
     *            kj2(NESQR), i, j, n1p, n2p
      REAL
     *            smin, smax, xi1, eta1, xi2, eta2, dxi, deta,
     *            xhat1, yhat1, xhat2, yhat2, dx, dy, rc, rs, stest
c
c...Make A List Of DX/DY For List (1)
c
  100 nl1 = 0
      n1p = nextract(1)
      DO i=1,n1p
        DO j=1,n1p
          IF (i.ne.j) THEN
            nl1 = nl1+1
            dx1(nl1) = xextract(j,1)-xextract(i,1)
            dy1(nl1) = yextract(j,1)-yextract(i,1)
            ii1(nl1) = i
            jj1(nl1) = j
            idx(nl1) = nl1
          ENDIF
        ENDDO
      ENDDO
      CALL iuqsrt(nl1,dx1,idx)
      CALL ireord(nl1,idx,dy1,tmp)
      CALL ireord(nl1,idx,ii1,tmp)
      CALL ireord(nl1,idx,jj1,tmp)
c
c...Make A list Of DX/DY For List (2)
c
      nl2 = 0
      n2p = nextract(2)
      DO i=1,n2p
        DO j=1,n2p
          IF (i.ne.j) THEN
            nl2 = nl2+1
            dx2(nl2) = xextract(j,2)-xextract(i,2)
            dy2(nl2) = yextract(j,2)-yextract(i,2)
            ii2(nl2) = i
            jj2(nl2) = j
            idx(nl2) = nl2
          ENDIF
        ENDDO
      ENDDO
      CALL iuqsrt(nl2,dx2,idx)
      CALL ireord(nl2,idx,dy2,tmp)
      CALL ireord(nl2,idx,ii2,tmp)
      CALL ireord(nl2,idx,jj2,tmp)
c
c...See If There Are Matches Within The Specified Tolerance
c
      smin = (1.0-stol)
      smax = (1.0+stol)
      stest = SQRT(stol)
      nkeep = 0
      test = 0
      low = 1
      high = 1
  110 test = test+1
      IF (test.gt.nl1) GO TO 140
      IF (dx1(test).lt.0) THEN
        xmin = smax*dx1(test)
        xmax = smin*dx1(test)
      ELSE
        xmin = smin*dx1(test)
        xmax = smax*dx1(test)
      ENDIF
      IF (dy1(test).lt.0) THEN
        ymin = smax*dy1(test)
        ymax = smin*dy1(test)
      ELSE
        ymin = smin*dy1(test)
        ymax = smax*dy1(test)
      ENDIF
  120 IF (dx2(low).lt.xmin) THEN
        IF (low.lt.nl2) THEN
          low = low+1
          GO TO 120
        ELSE
          GO TO 110
        ENDIF
      ENDIF
      IF (dx2(low).gt.xmax) GO TO 110
      IF (high.lt.low) THEN
        high = low
      ENDIF
  130 IF (high.lt.nl2) THEN
        IF (dx2(high+1).le.xmax) THEN
          high = high+1
          GO TO 130
        ENDIF
      ENDIF
c
c...Test In DY And Save Matches
c
      DO i=low,high
        IF ((dy2(i).ge.ymin).and.(dy2(i).le.ymax)) THEN
          nkeep = nkeep+1
          ki1(nkeep) = ii1(test)
          kj1(nkeep) = jj1(test)
          ki2(nkeep) = ii2(i)
          kj2(nkeep) = jj2(i)
        ENDIF
      ENDDO
      GO TO 110
c
c...Just Try Entries In The List Until We Get A Good Match
c
  140 CONTINUE
      DO i=1,nkeep
        xi1  = xextract(ki1(i),1)/SCALE
        eta1 = yextract(ki1(i),1)/SCALE
        xi2  = xextract(kj1(i),1)/SCALE
        eta2 = yextract(kj1(i),1)/SCALE
        xhat1 = xextract(ki2(i),2)/SCALE
        yhat1 = yextract(ki2(i),2)/SCALE
        xhat2 = xextract(kj2(i),2)/SCALE
        yhat2 = yextract(kj2(i),2)/SCALE
        dxi = xi2-xi1
        deta = eta2-eta1
        dx = xhat2-xhat1
        dy = yhat2-yhat1
        rc = (dxi*dx + deta*dy)/(dx*dx + dy*dy)
        rs = (dxi*dy - deta*dx)/(dx*dx + dy*dy)
        xcoef(1,3) = xi1 - (rc*xhat1 + rs*yhat1)
        xcoef(2,3) = rc
        xcoef(3,3) = rs
        ycoef(1,3) = eta1 - (rc*yhat1 - rs*xhat1)
        ycoef(2,3) = -rs
        ycoef(3,3) = rc
        ncoef(3) = 3
        sigmax(3) = 0.0D00
        sigmay(3) = 0.0D00
        IF ((rc.ge.smin).and.(rc.le.smax).and.(ABS(rs).le.stest)) THEN
          CALL dstxform(3)
          CALL dstfind
          IF (npover.gt.5) GO TO 150
        ENDIF
      ENDDO
  150 CONTINUE
      RETURN
      END
