      SUBROUTINE  manplot(fatal)
c
c...Plot And Solve By Hand
c
      INCLUDE
     *            'joeproc.inc'
      PARAMETER
     *            tomm = 1.0/100000.0
      INTEGER
     *         i, in(6), nn, x1min, x1max, y1min, y1max, x2min, x2max,
     *         y2min, y2max, fatal, err
      REAL
     *         xmin, xmax, ymin, ymax, x, y, x1mean, x1wide, y1mean,
     *         y1wide, x2mean, x2wide, y2mean, y2wide, wide, t0, t
      CHARACTER*4
     *         lb
c
 9001 FORMAT (6i12)
 9002 FORMAT ('+', i1)
 9003 FORMAT ('+', i2)
 9004 FORMAT ('+', i3)
 9005 FORMAT (' Pair(', i2, '): ' $)
 9006 FORMAT (q, 2i10)
c
c...Recover Disk Version Of AUTOEXT.LIS
c
  100 OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=200,
     *      form='formatted',
     *      name='autoext.lis',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      nn = 0
  110 READ (1,9001,end=120) (in(i),i=1,6)
      nn = nn+1
      xextract(nn,1) = in(1)
      yextract(nn,1) = in(2)
      mextract(nn,1) = in(3)
      xextract(nn,2) = in(4)
      yextract(nn,2) = in(5)
      mextract(nn,2) = in(6)
      nextract(1) = nn
      nextract(2) = nn
      IF (nn.eq.1) THEN
        x1min = xextract(nn,1)
        x1max = x1min
        y1min = yextract(nn,1)
        y1max = y1min
        x2min = xextract(nn,2)
        x2max = x2min
        y2min = yextract(nn,2)
        y2max = y2min
      ELSE
        x1min = MIN(x1min,xextract(nn,1))
        x1max = MAX(x1max,xextract(nn,1))
        y1min = MIN(y1min,yextract(nn,1))
        y1max = MAX(y1max,yextract(nn,1))
        x2min = MIN(x2min,xextract(nn,2))
        x2max = MAX(x2max,xextract(nn,2))
        y2min = MIN(y2min,yextract(nn,2))
        y2max = MAX(y2max,yextract(nn,2))
      ENDIF
      GO TO 110
  120 CLOSE (1)
c
c...Compute Plotting Parameters And Use MONGO
c
      x1mean = TOMM*(x1max+x1min)/2.0
      x1wide = TOMM*(x1max-x1min)
      y1mean = TOMM*(y1max+y1min)/2.0
      y1wide = TOMM*(y1max-y1min)
      x2mean = TOMM*(x2max+x2min)/2.0
      x2wide = TOMM*(x2max-x2min)
      y2mean = TOMM*(y2max+y2min)/2.0
      y2wide = TOMM*(y2max-y2min)
      wide = 0.5*MAX(x1wide,y1wide,x2wide,y2wide)
      xmin = x1mean - wide
      xmax = x1mean + wide
      ymin = y1mean - wide
      ymax = y1mean + wide
      CALL mgoinit
      CALL mgosetup(-7)
      CALL mgoerase
      CALL mgosetlim(xmin,ymin,xmax,ymax)
      CALL mgobox(1,1)
      CALL mgorelocate(xmin,ymin)
      CALL mgoputlabel(5,'List1',9)
      DO i=1,nextract(1)
        x = TOMM*xextract(i,1)
        y = TOMM*yextract(i,1)
        CALL mgorelocate(x,y)
        IF (i.le.9) THEN
          WRITE (lb,9002) i
          nn = 2
        ELSEIF (i.le.99) THEN
          WRITE (lb,9003) i
          nn = 3
        ELSE
          WRITE (lb,9004) i
          nn = 4
        ENDIF
        CALL mgoputlabel(nn,lb,6)
      ENDDO
      CALL mgoprntplot(i)
      t0 = SECNDS(0.0)
  130 t = SECNDS(t0)
      IF (t.le.3.0) GO TO 130
      xmin = x2mean - wide
      xmax = x2mean + wide
      ymin = y2mean - wide
      ymax = y2mean + wide
      CALL mgoerase
      CALL mgosetlim(xmin,ymin,xmax,ymax)
      CALL mgobox(1,1)
      CALL mgorelocate(xmin,ymin)
      CALL mgoputlabel(5,'List2',9)
      DO i=1,nextract(2)
        x = TOMM*xextract(i,2)
        y = TOMM*yextract(i,2)
        CALL mgorelocate(x,y)
        IF (i.le.9) THEN
          WRITE (lb,9002) i
          nn = 2
        ELSEIF (i.le.99) THEN
          WRITE (lb,9003) i
          nn = 3
        ELSE
          WRITE (lb,9004) i
          nn = 4
        ENDIF
        CALL mgoputlabel(nn,lb,6)
      ENDDO
      CALL mgoprntplot(i)
c
c...Manual Input Of Pairs
c
  140 npover = 0
  150 i = npover+1
      WRITE (*,9005) i
      READ  (*,9006,err=140,end=200) i,in(1),in(2)
      IF (i.le.0) THEN
        IF (npover.ge.6) THEN
          GO TO 160
        ELSE
          GO TO 150
        ENDIF
      ELSE
        IF ((in(1).le.0).or.(in(1).gt.nextract(1))) THEN
          GO TO 150
        ENDIF
        IF ((in(2).le.0).or.(in(2).gt.nextract(2))) THEN
          GO TO 150
        ENDIF
        npover = npover+1
        pover1(npover) = in(1)
        pover2(npover) = in(2)
      ENDIF
      GO TO 150
c
c...Fit Pairs List
c
  160 CALL dstfit(xextract(1,1),xexres(1),xcoef(1,3),sxcoef(1,3),
     *            sigmax(3),err)
      IF (err.ne.0) THEN
        fatal = 5
        RETURN
      ENDIF
      CALL dstfit(yextract(1,1),yexres(1),ycoef(1,3),sycoef(1,3),
     *            sigmay(3),err)
      IF (err.ne.0) THEN
        fatal = 6
        RETURN
      ENDIF
      fatal = 0
      RETURN
c
c...Error Return
c
  200 fatal = 1
      RETURN
      END
