      SUBROUTINE  poss2load
c
c...Look In Database To Fill In Exposure Info
c
      INCLUDE
     *            'joeproc.inc'
      PARAMETER
     *            palomar = 33.357D00
      DOUBLE PRECISION
     *            a, b, c, czd, x, y, z, rr, dd, hh, zz, tt
      INTEGER
     *            nlb, field, i, ix, iy, j, year, month, day,
     *            yy, mm, dn, nt
      CHARACTER*132
     *            lb
      CHARACTER*3
     *            mon, monlist(12)
      CHARACTER*2
     *            o
      DATA
     *   monlist/'JAN', 'FEB', 'MAR', 'APR', 'MAY', 'JUN',
     *           'JUL', 'AUG', 'SEP', 'OCT', 'NOV', 'DEC'/
c
 9001 FORMAT (q, a)
 9002 FORMAT (i4)
 9003 FORMAT (2i2, f2.0)
 9004 FORMAT (f1.0, 1x, f2.0)
 9005 FORMAT (' Fatal Error', 5(' >>', a, '<<'))
 9006 FORMAT (i2, a, i2)
 9007 FORMAT (f2.0, 1x, f2.0)
 9008 FORMAT (f3.0)
c
c...Open Catalog
c
  100 OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='/uz6/xpmm/sg5/tycho/possii.cat',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=77
     *     )
      READ (77,9001)
      nt = 0
c
c...Load Everybody For AUTO
c
  110 READ (77,9001,err=110,end=130) nlb,lb
      IF (nlb.le.0) GO TO 110
      o = lb(8:9)
      READ (lb(3:6),9002,err=200) field
      READ (lb(30:35),9003,err=200) ix,iy,z
      CALL sla_DTF2R(ix,iy,z, rr,j)
      READ (lb(38:43),9003,err=200) ix,iy,z
      CALL sla_DAF2R(ix,iy,z, dd,j)
      IF (lb(37:37).eq.'-') THEN
        dd = -dd
      ENDIF
      READ (lb(84:87),9004,err=200) x,y
      hh = x + y/60.0D00
      IF (lb(88:88).eq.'E') THEN
        hh = -hh
      ENDIF
      READ (lb(24:28),9007) x,y
      READ (lb(79:81),9008) z
      tt = x + y/60.0D00 + z/120.0D00
c
c...Crack DDMONYY Format
c
      READ (lb(16:22),9006,err=200) dn,mon,yy
      DO i=1,12
        IF (mon.eq.monlist(i)) THEN
          mm = i
          GO TO 120
        ENDIF
      ENDDO
      GO TO 200
c
c...Compute ZD
c
  120 b = 90.0D00 - PALOMAR
      c = 90.0D00 - dd*radian
      czd = COSD(b)*COSD(c) + SIND(b)*SIND(c)*COSD(hh*15.0D00)
      zz = ACOSD(czd)
c
c...Fill Our Slots
c
      DO i=1,4
        IF (o.eq.order(i)) THEN
          possra(field,i) = rr
          possdec(field,i) = dd
          possha(field,i) = hh
          posszd(field,i) = zz
          possut(field,i) = tt
          possyy(field,i) = yy
          possmm(field,i) = mm
          possdd(field,i) = dn
          nt = nt+1
        ENDIF
      ENDDO
      GO TO 110
  130 CLOSE (77)
      RETURN
c
c...Problems
c
  200 WRITE (*,9005) lb(3:6),lb(30:35),lb(37:43),lb(84:88),lb(16:22)
      CLOSE (77)
      CALL EXIT
      END
