      SUBROUTINE  fit2(ncoef)
c
c...Least Squares Fit To Pairs
c
      INCLUDE
     *            'phcal.inc'
      DOUBLE PRECISION
     *            chisq, x, y, yy, yr
      INTEGER
     *            i, j, k, ncoef, ising, nin
c
 9001 FORMAT (' Singular Matrix In FIT2')
c
c...Initialization
c
  100 DO i=1,ncoef
        zlhs(i) = 0.0D00
        coef(i) = 0.0D00
        DO j=1,ncoef
          zrhs(i,j) = 0.0D00
        ENDDO
      ENDDO
      chisq = 0.0D00
      nin = 0
c
c...Accumulation
c
      DO i=1,nspl
        IF (infit(i).ne.0) THEN
          x = splx(i)
          y = sply(i)
          dv(1) = 1.0D00
          DO j=2,ncoef
            dv(j) = dv(j-1)*x
          ENDDO
          DO j=1,ncoef
            zlhs(j) = zlhs(j) + dv(j)*y
            DO k=1,ncoef
              zrhs(j,k) = zrhs(j,k) + dv(j)*dv(k)
            ENDDO
          ENDDO
          nin = nin+1
        ENDIF
      ENDDO
c
c...Inversion
c
      CALL matinv(ncoef,ising)
      IF (ising.ne.0) THEN
        WRITE (*,9001)
        CALL EXIT
      ENDIF
c
c...Coefficients
c
      DO i=1,ncoef
        DO j=1,ncoef
          coef(i) = coef(i) + zrhs(i,j)*zlhs(j)
        ENDDO
      ENDDO
c
c...Residuals and Chi Sqaured
c
      DO i=1,nspl
        x = splx(i)
        y = sply(i)
        dv(1) = 1.0D00
        DO j=2,ncoef
          dv(j) = dv(j-1)*x
        ENDDO
        yy = 0.0D00
        DO j=1,ncoef
          yy = yy + coef(j)*dv(j)
        ENDDO
        yr = y-yy
        IF (infit(i).ne.0) THEN
          chisq = chisq + yr*yr
        ENDIF
        se(i) = yr
      ENDDO
c
c...Errors
c
      stderr = SQRT(chisq/(nin-(ncoef+1)))
      DO i=1,ncoef
        scoef(i) = stderr*SQRT(zrhs(i,i))
      ENDDO
      RETURN
      END
