      SUBROUTINE  fit5(mode)
c
c...Fit FIND1 Pairs Using Smoothing Spline
c
      INCLUDE
     *            'phcal.inc'
      PARAMETER
     *            trivial = 0.01D00
      INTEGER
     *            i, j, mode, ier
      DOUBLE PRECISION
     *            yvar, t, x, dx, dy, halfwide
c
 9001 FORMAT (' Too Few Points In FIT1 ', i10)
 9002 FORMAT (' CUBGCV in FIT1 Returns IER=', i10)
c
c...Sanity Check
c
  100 IF (np.le.5) THEN
        WRITE (*,9001) np
        RETURN
      ENDIF
c
c...Sort Pairs On X
c
      DO i=1,np
        jdx(i) = i
      ENDDO
      CALL iuqsrt(np,px,jdx)
      CALL ireord(np,jdx,py,tmp)
      CALL ireord(np,jdx,pr,tmp)
      CALL ireord(np,jdx,pq,tmp)
      CALL ireord(np,jdx,ps,tmp)
c
c...Load Into DP Variables Resolving Equlaities
c
      nspl = 0
      DO i=1,np
        IF (infit(i).ne.0) THEN
          nspl = nspl+1
          splx(nspl) = px(i)
          sply(nspl) = py(i)
          IF (nspl.gt.1) THEN
            IF (splx(nspl).le.splx(nspl-1)) THEN
              splx(nspl) = splx(nspl-1)+TRIVIAL
            ENDIF
          ENDIF
        ENDIF
      ENDDO
c
c...Sanity Check
c
      CALL sanity
c
c...Optional Smoothing
c
      IF (mode.ne.0) THEN
        halfwide = MIN(75.0D00,MAX(25.0D00,2200.0D00/nspl))
        CALL smooth(halfwide)
      ENDIF
c
c...Compute Smoothing Spline
c
      DO i=1,nspl
        yw(i) = 1.0D00
      ENDDO
      yvar = -1.0D00
      CALL cubgcv(splx,sply,yw,nspl, yc,ycoef,NCODIM,
     *            yvar,0,se,wk,ier)
      IF (ier.ne.0) THEN
        WRITE (*,9002) ier
        CALL EXIT
      ENDIF
      DO i=1,nspl
        se(i) = sply(i)-yc(i)
      ENDDO
      length = 0.0D00
      DO i=2,nspl
        dx = splx(i)-splx(i-1)
        dy = yc(i)-yc(i-1)
        length = length + SQRT(dx*dx + dy*dy)
      ENDDO
c
c...Fill The FIT Delta Magnitude Array
c
      j = 1
      rangemin = MAGTAG
      DO i=BRIGHTMAG,FAINTMAG
        x = i
  110   IF (x.lt.splx(j)) THEN
          fitdm(i) = yc(1)
        ELSEIF ((x.ge.splx(j)).and.(x.le.splx(j+1))) THEN
          dx = x-splx(j)
          fitdm(i) = yc(j)
     *             + dx*(ycoef(j,1) + dx*(ycoef(j,2) + dx*ycoef(j,3)))
          IF (rangemin.eq.MAGTAG) THEN
            rangemin = fitdm(i)
            rangemax = fitdm(i)
          ELSE
            rangemin = MIN(rangemin,fitdm(i))
            rangemax = MAX(rangemax,fitdm(i))
          ENDIF
        ELSE
          j = j+1
          IF (j.lt.nspl) THEN
            GO TO 110
          ELSE
            GO TO 120
          ENDIF
        ENDIF
      ENDDO
  120 IF (i.le.FAINTMAG) THEN
        DO j=i,FAINTMAG
          fitdm(j) = yc(nspl)
        ENDDO
      ENDIF
      RETURN
      END
