      SUBROUTINE  magverify(id)
c
c...Make Sure Magnitudes Work And Save Statistics
c
      INCLUDE
     *            'tbproc.inc'
      PARAMETER
     *            nhist = 16,
     *            slop = 5*1000*100
      INTEGER
     *            i, j, i1, i2, hist(NHIST), find(NHIST), ratio(NHIST),
     *            bright, faint, ok, id, nfind
      DOUBLE PRECISION
     *            x, y, xhat, yhat, dv(NCMAX), sigma
c
 9001 FORMAT (i3, f5.2, 17i4)
c
c...Transform Corners Of (2) To Get Limits For (1)
c
  100 x2min = x2(pair2(1))
      x2max = x2min
      y2min = y2(pair2(1))
      y2max = y2min
      DO i=2,npair
        j = x2(pair2(i))
        x2min = MIN(x2min,j)
        x2max = MAX(x2max,j)
        j = y2(pair2(i))
        y2min = MIN(y2min,j)
        y2max = MAX(y2max,j)
      ENDDO
      DO i=1,2
        IF (i.eq.1) THEN
          x = x2min/SCALE
          y = y2min/SCALE
        ELSE
          x = x2max/SCALE
          y = y2max/SCALE
        ENDIF
        xhat = 0.0D00
        yhat = 0.0D00
        dv( 1) = 1.0D00
        dv( 2) = x
        dv( 3) = y
        dv( 4) = x*x
        dv( 5) = x*y
        dv( 6) = y*y
        dv( 7) = x*x*x
        dv( 8) = x*x*y
        dv( 9) = x*y*y
        dv(10) = y*y*y
        DO j=1,ncoef
          xhat = xhat + dv(j)*xcoef(j)
          yhat = yhat + dv(j)*ycoef(j)
        ENDDO
        IF (i.eq.1) THEN
          x1min = xhat*SCALE + SLOP
          y1min = yhat*SCALE + SLOP
        ELSE
          x1max = xhat*SCALE - SLOP
          y1max = yhat*SCALE - SLOP
        ENDIF
      ENDDO
c
c...Histogram (1) That Should Have Been Found On (2)
c
      DO i=1,NHIST
        hist(i) = 0
        find(i) = 0
      ENDDO
      bright = 0
      faint = 0
      ok = 0
      DO i=1,n1
        tmp(i) = -1
        IF  ((x1(i).ge.x1min).and.(x1(i).le.x1max)
     *  .and.(y1(i).ge.y1min).and.(y1(i).le.y1max)) THEN
          j = d1(i)/100
          IF (j.lt.1) THEN
            bright = bright+1
          ELSEIF (j.gt.NHIST) THEN
            faint = faint+1
          ELSE
            ok = ok+1
            hist(j) = hist(j)+1
            tmp(i) = 0
          ENDIF
        ENDIF
      ENDDO
c
c...Examine The Pairs And Sort The Residuals
c
      DO i=1,npair
        i1 = pair1(i)
        i2 = pair2(i)
        IF (tmp(i1).eq.0) THEN
          x = d2(i2)
          dv(1) = 1.0D00
          xhat = mcoef(1)
          DO j=2,nmcoef
            dv(j) = dv(j-1)*x
            xhat = xhat + dv(j)*mcoef(j)
          ENDDO
          j = xhat
          tmp(i1) = ABS(d1(i1)-j)+1
          j = d1(i1)/100
          IF ((j.ge.1).and.(j.le.NHIST)) THEN
            find(j) = find(j)+1
          ENDIF
        ENDIF
      ENDDO
      nfind = 0
      DO i=1,n1
        IF (tmp(i).gt.0) THEN
          nfind = nfind+1
          tmp(nfind) = tmp(i)-1
          idx(nfind) = nfind
        ENDIF
      ENDDO
      CALL iuqsrt(nfind,tmp,idx)
c
c...Save Our Results
c
      DO i=1,NHIST
        IF (hist(i).le.0) THEN
          ratio(i) = -1
        ELSE
          x = find(i)
          y = hist(i)
          ratio(i) = 1000.0D00*x/y
        ENDIF
      ENDDO
      j = 0.68269D00*ok + 0.5D00
      sigma = 0.01D00*tmp(j)
      x = nfind
      y = ok
      j = 1000.0D00*x/y
      OPEN (
     *      access='append',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=200,
     *      form='formatted',
     *      name='tb.mag',
     *      status='unknown',
     *      unit=1
     *     )
      WRITE (1,9001) id,sigma,j,(ratio(i),i=1,NHIST)
      CLOSE (1)
  200 RETURN
      END
